/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader;

import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderLastStatus;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.google.gson.JsonObject;
import inet.ipaddr.IPAddress;
import java.util.Collection;
import java.util.List;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Downloader
extends AutoCloseable {
    @NotNull
    public YamlConfiguration saveDownloader();

    @NotNull
    public JsonObject saveDownloaderJson();

    @NotNull
    public String getEndpoint();

    @NotNull
    public String getName();

    @NotNull
    public String getId();

    @NotNull
    public String getType();

    public int getFailedLoginAttempts();

    @NotNull
    public DownloaderLoginResult login();

    public boolean isPaused();

    public void setPaused(boolean var1);

    default public void runScheduleTasks() {
    }

    @NotNull
    public List<Torrent> getTorrents();

    @NotNull
    public List<Torrent> getAllTorrents();

    @NotNull
    public List<Peer> getPeers(@NotNull Torrent var1);

    @NotNull
    public List<Tracker> getTrackers(@NotNull Torrent var1);

    public void setTrackers(@NotNull Torrent var1, @NotNull List<Tracker> var2);

    public void setBanList(@NotNull Collection<IPAddress> var1, @Nullable Collection<BanMetadata> var2, @Nullable Collection<BanMetadata> var3, boolean var4);

    @NotNull
    public DownloaderLastStatus getLastStatus();

    public void setLastStatus(@NotNull DownloaderLastStatus var1, @NotNull TranslationComponent var2);

    @NotNull
    public TranslationComponent getLastStatusMessage();

    @NotNull
    public DownloaderStatistics getStatistics();

    @NotNull
    public List<DownloaderFeatureFlag> getFeatureFlags();

    public int getMaxConcurrentPeerRequestSlots();

    @Nullable
    public DownloaderSpeedLimiter getSpeedLimiter();

    public void setSpeedLimiter(@NotNull DownloaderSpeedLimiter var1);

    public int getBTProtocolPort();

    public void setBTProtocolPort(int var1);
}

