/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.text;

import com.ghostchu.peerbanhelper.text.LanguageFilesManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageFilesManagerImpl
implements LanguageFilesManager {
    private final Map<String, YamlConfiguration> locale2ContentMapping = new ConcurrentHashMap<String, YamlConfiguration>();

    @Override
    public void deploy(@NotNull String locale, @NotNull YamlConfiguration newDistribution) {
        if (!this.locale2ContentMapping.containsKey(locale)) {
            this.locale2ContentMapping.put(locale, newDistribution);
        } else {
            YamlConfiguration exists = this.locale2ContentMapping.get(locale);
            this.merge(exists, newDistribution);
        }
    }

    private void merge(@NotNull YamlConfiguration alreadyRegistered, @NotNull YamlConfiguration newConfiguration) {
        for (String key : newConfiguration.getKeys(true)) {
            if (newConfiguration.isConfigurationSection(key)) continue;
            alreadyRegistered.set(key, newConfiguration.get(key));
        }
    }

    public void fillMissing(@NotNull YamlConfiguration fallback) {
        for (YamlConfiguration value : this.locale2ContentMapping.values()) {
            this.mergeMissing(value, fallback);
        }
    }

    private void mergeMissing(@NotNull YamlConfiguration alreadyRegistered, @NotNull YamlConfiguration newConfiguration) {
        for (String key : newConfiguration.getKeys(true)) {
            if (newConfiguration.isConfigurationSection(key) || alreadyRegistered.isSet(key)) continue;
            alreadyRegistered.set(key, newConfiguration.get(key));
        }
    }

    @Override
    public void destroy(@NotNull String locale) {
        this.locale2ContentMapping.remove(locale);
    }

    @Override
    @Nullable
    public YamlConfiguration getDistribution(@NotNull String locale) {
        return this.locale2ContentMapping.get(locale);
    }

    @Override
    @NotNull
    public Map<String, YamlConfiguration> getDistributions() {
        return this.locale2ContentMapping;
    }

    @Override
    public void remove(@NotNull String distributionPath) {
        this.locale2ContentMapping.remove(distributionPath);
    }

    @Override
    public void remove(@NotNull String distributionPath, @NotNull String locale) {
        if (this.locale2ContentMapping.containsKey(distributionPath)) {
            this.locale2ContentMapping.remove(locale);
        }
    }

    @Override
    public void reset() {
        this.locale2ContentMapping.clear();
    }
}

