/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;

public final class MiscUtil {
    public static final Object EMPTY_OBJECT = new Object();
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");

    public static String formatDateOnly(long timestamp) {
        return sdfDate.format(new Date(timestamp));
    }

    public static String formatDateTime(long timestamp) {
        return sdf.format(new Date(timestamp));
    }

    public static String formatTimeOnly(long timestamp) {
        return sdfTime.format(new Date(timestamp));
    }

    public static void gzip(InputStream is, OutputStream os) throws IOException {
        int bytesRead;
        GZIPOutputStream gzipOs = new GZIPOutputStream(os);
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) > -1) {
            gzipOs.write(buffer, 0, bytesRead);
        }
        gzipOs.close();
    }

    public static boolean isClassAvailable(@NotNull String qualifiedName) {
        try {
            Class.forName(qualifiedName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<File> recursiveReadFile(File fileOrDir) {
        ArrayList<File> files = new ArrayList<File>();
        if (fileOrDir == null) {
            return files;
        }
        if (fileOrDir.isFile()) {
            files.add(fileOrDir);
        } else {
            for (File file : Objects.requireNonNull(fileOrDir.listFiles())) {
                files.addAll(MiscUtil.recursiveReadFile(file));
            }
        }
        return files;
    }

    public static ZoneOffset getSystemZoneOffset() {
        return ZoneId.systemDefault().getRules().getOffset(Instant.now());
    }

    public static long getStartOfToday(long time) {
        ZoneId systemZone = ZoneId.systemDefault();
        ZoneOffset currentOffsetForMyZone = systemZone.getRules().getOffset(Instant.ofEpochMilli(time));
        LocalDate date = Instant.ofEpochMilli(time).atZone(systemZone).toLocalDate();
        return date.atStartOfDay().toInstant(currentOffsetForMyZone).toEpochMilli();
    }

    public static long getEndOfToday(long time) {
        ZoneId systemZone = ZoneId.systemDefault();
        ZoneOffset currentOffsetForMyZone = systemZone.getRules().getOffset(Instant.now());
        LocalDateTime dateTime = Instant.ofEpochMilli(time).atZone(systemZone).toLocalDateTime();
        LocalDateTime dayEnd = dateTime.withHour(23).withMinute(59).withSecond(59).withNano(999999999);
        return dayEnd.toInstant(currentOffsetForMyZone).toEpochMilli();
    }

    public static long getStartOfHour(long time) {
        ZoneId systemZone = ZoneId.systemDefault();
        ZoneOffset currentOffsetForMyZone = systemZone.getRules().getOffset(Instant.now());
        LocalDateTime dateTime = Instant.ofEpochMilli(time).atZone(systemZone).toLocalDateTime();
        LocalDateTime hourStart = dateTime.withMinute(0).withSecond(0).withNano(0);
        return hourStart.toInstant(currentOffsetForMyZone).toEpochMilli();
    }

    public static boolean is64BitJVM() {
        String dataModel = System.getProperty("sun.arch.data.model");
        if (dataModel != null) {
            return "64".equals(dataModel);
        }
        String arch = System.getProperty("os.arch");
        List<String> arch64 = Arrays.asList("x86_64", "amd64", "aarch64", "ppc64", "ppc64le", "s390x", "sparcv9", "ia64");
        if (arch64.contains(arch)) {
            return true;
        }
        String vmName = System.getProperty("java.vm.name", "").toLowerCase();
        return vmName.contains("64");
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static int randomAvailablePort() {
        try {
            ServerSocket tmpSocket = new ServerSocket(0);
            int localPort = tmpSocket.getLocalPort();
            tmpSocket.close();
            return localPort;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

