/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.maxmind.db.Network;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class NetworkDeserializer
extends StdDeserializer<Network> {
    public NetworkDeserializer() {
        this(null);
    }

    public NetworkDeserializer(Class<?> vc) {
        super(vc);
    }

    public Network deserialize(JsonParser jsonparser, DeserializationContext context) throws IOException {
        String cidr = jsonparser.getValueAsString();
        if (cidr == null || cidr.isBlank()) {
            return null;
        }
        return NetworkDeserializer.parseCidr(cidr);
    }

    private static Network parseCidr(String cidr) throws IOException {
        int maxPrefix;
        InetAddress address;
        String[] parts = cidr.split("/", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid CIDR format: " + cidr);
        }
        String addrPart = parts[0];
        String prefixPart = parts[1];
        try {
            address = InetAddress.getByName(addrPart);
        }
        catch (UnknownHostException e) {
            throw new IOException("Unknown host in CIDR: " + cidr, e);
        }
        int prefixLength = NetworkDeserializer.parsePrefixLength(prefixPart, cidr);
        int n = maxPrefix = address.getAddress().length == 4 ? 32 : 128;
        if (prefixLength < 0 || prefixLength > maxPrefix) {
            throw new IllegalArgumentException("Prefix length out of range (0-" + maxPrefix + ") for CIDR: " + cidr);
        }
        return new Network(address, prefixLength);
    }

    private static int parsePrefixLength(String prefixPart, String cidr) {
        try {
            return Integer.parseInt(prefixPart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid prefix length in CIDR: " + cidr, e);
        }
    }
}

