/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MergedAnnotationReadingVisitor;
import org.springframework.core.type.classreading.SimpleAnnotationMetadata;
import org.springframework.core.type.classreading.SimpleMethodMetadataReadingVisitor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class SimpleAnnotationMetadataReadingVisitor
extends ClassVisitor {
    private final @Nullable ClassLoader classLoader;
    private String className = "";
    private int access;
    private @Nullable String superClassName;
    private @Nullable String enclosingClassName;
    private boolean independentInnerClass;
    private final Set<String> interfaceNames = new LinkedHashSet<String>(4);
    private final Set<String> memberClassNames = new LinkedHashSet<String>(4);
    private final Set<MergedAnnotation<?>> annotations = new LinkedHashSet(4);
    private final Set<MethodMetadata> declaredMethods = new LinkedHashSet<MethodMetadata>(4);
    private @Nullable SimpleAnnotationMetadata metadata;
    private @Nullable Source source;

    SimpleAnnotationMetadataReadingVisitor(@Nullable ClassLoader classLoader) {
        super(0x10A0000);
        this.classLoader = classLoader;
    }

    @Override
    public void visit(int version, int access, String name, String signature, @Nullable String supername, String[] interfaces) {
        this.className = this.toClassName(name);
        this.access = access;
        if (supername != null && !this.isInterface(access)) {
            this.superClassName = this.toClassName(supername);
        }
        for (String element : interfaces) {
            this.interfaceNames.add(this.toClassName(element));
        }
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.enclosingClassName = this.toClassName(owner);
    }

    @Override
    public void visitInnerClass(String name, @Nullable String outerName, String innerName, int access) {
        if (outerName != null) {
            String className = this.toClassName(name);
            String outerClassName = this.toClassName(outerName);
            if (this.className.equals(className)) {
                this.enclosingClassName = outerClassName;
                this.independentInnerClass = (access & 8) != 0;
            } else if (this.className.equals(outerClassName)) {
                this.memberClassNames.add(className);
            }
        }
    }

    @Override
    public @Nullable AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return MergedAnnotationReadingVisitor.get(this.classLoader, this.getSource(), descriptor, visible, this.annotations::add);
    }

    @Override
    public @Nullable MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.isBridge(access) || name.equals("<init>")) {
            return null;
        }
        return new SimpleMethodMetadataReadingVisitor(this.classLoader, this.className, access, name, descriptor, this.declaredMethods::add);
    }

    @Override
    public void visitEnd() {
        MergedAnnotations annotations = MergedAnnotations.of(this.annotations);
        this.metadata = new SimpleAnnotationMetadata(this.className, this.access, this.enclosingClassName, this.superClassName, this.independentInnerClass, this.interfaceNames, this.memberClassNames, this.declaredMethods, annotations);
    }

    public SimpleAnnotationMetadata getMetadata() {
        Assert.state(this.metadata != null, "AnnotationMetadata not initialized");
        return this.metadata;
    }

    private Source getSource() {
        Source source = this.source;
        if (source == null) {
            this.source = source = new Source(this.className);
        }
        return source;
    }

    private String toClassName(String name) {
        return ClassUtils.convertResourcePathToClassName(name);
    }

    private boolean isBridge(int access) {
        return (access & 0x40) != 0;
    }

    private boolean isInterface(int access) {
        return (access & 0x200) != 0;
    }

    private static final class Source {
        private final String className;

        Source(String className) {
            this.className = className;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof Source)) return false;
            Source that = (Source)other;
            if (!this.className.equals(that.className)) return false;
            return true;
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        public String toString() {
            return this.className;
        }
    }
}

