/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public final class UrlEncoderDecoder {
    private static final BitSet safeCharacters;
    private static final char[] hexadecimal;

    public static String decodePath(String path) throws IOException {
        int maxBytesPerChar = 10;
        StringBuilder bufferPath = new StringBuilder(path);
        ByteArrayOutputStream decodePath = new ByteArrayOutputStream(maxBytesPerChar);
        for (int i = 0; i < bufferPath.length(); ++i) {
            if (bufferPath.charAt(i) != '%') {
                decodePath.write(bufferPath.charAt(i));
                continue;
            }
            char mixChar = (char)Integer.parseInt(bufferPath.substring(i + 1, i + 3), 16);
            i += 2;
            decodePath.write(mixChar);
        }
        return decodePath.toString(StandardCharsets.UTF_8);
    }

    public static String encodePath(String path) {
        OutputStreamWriter writer;
        int maxBytesPerChar = 10;
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        try {
            writer = new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            byte[] ba;
            char c = path.charAt(i);
            if (safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    public static String encodeToLegalPath(String path) {
        OutputStreamWriter writer;
        int maxBytesPerChar = 10;
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        try {
            writer = new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            byte[] ba;
            char c = path.charAt(i);
            if (safeCharacters.get(c) || (char)c == '%') {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    static {
        int i;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            safeCharacters.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            safeCharacters.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            safeCharacters.set(i);
        }
        safeCharacters.set(36);
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(43);
        safeCharacters.set(33);
        safeCharacters.set(42);
        safeCharacters.set(39);
        safeCharacters.set(40);
        safeCharacters.set(41);
        safeCharacters.set(44);
        safeCharacters.set(47);
        safeCharacters.set(58);
        safeCharacters.set(64);
        safeCharacters.set(38);
        safeCharacters.set(61);
    }
}

