/*
 * Decompiled with CFR 0.152.
 */
package cordelia.rpc;

import com.google.gson.annotations.SerializedName;
import cordelia.client.TypedRequest;
import cordelia.rpc.ReqMethod;
import cordelia.rpc.RsArguments;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public interface RqArguments {
    default public Class<? extends RsArguments> answerClass() {
        ReqMethod reqAnn = this.getClass().getAnnotation(ReqMethod.class);
        if (reqAnn == null || reqAnn.answer() == null) {
            throw new IllegalArgumentException("no response class provided");
        }
        return reqAnn.answer();
    }

    default public TypedRequest toReq(Long tag) {
        ReqMethod reqAnn = this.getClass().getAnnotation(ReqMethod.class);
        if (reqAnn == null || reqAnn.value() == null || reqAnn.value().isEmpty()) {
            throw new IllegalArgumentException("no method provided");
        }
        return new TypedRequest(tag, reqAnn.value(), this.collectFields());
    }

    default public Map<String, Object> collectFields() {
        Field[] fields;
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.trySetAccessible();
            Object value = field.get(this);
            if (value == null) continue;
            SerializedName jp = field.getAnnotation(SerializedName.class);
            String fieldName = jp == null ? field.getName() : jp.value();
            arguments.put(fieldName, value);
        }
        return arguments;
    }
}

