/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.managers.CityExpansionManager;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.HexMathKt;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0000J\b\u0010\u0011\u001a\u00020\u000bH\u0007J\b\u0010\u0012\u001a\u00020\u000bH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0007J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0007J\u0006\u0010\u001d\u001a\u00020\u0018J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/unciv/logic/city/managers/CityExpansionManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "setCity", "(Lcom/unciv/logic/city/City;)V", "cultureStored", "", "getCultureStored", "()I", "setCultureStored", "(I)V", "clone", "tilesClaimed", "getCultureToNextTile", "canBuyTile", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "buyTile", "", "getGoldCostOfTile", "getChoosableTiles", "Lkotlin/sequences/Sequence;", "chooseNewTileToOwn", "reset", "addNewTileWithCulture", "Lcom/badlogic/gdx/math/Vector2;", "relinquishOwnership", "takeOwnership", "nextTurn", "culture", "", "setTransients", "core"})
@SourceDebugExtension(value={"SMAP\nCityExpansionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityExpansionManager.kt\ncom/unciv/logic/city/managers/CityExpansionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1788#2,4:227\n1255#3,2:231\n2275#3,2:233\n1923#3,14:235\n1#4:249\n*S KotlinDebug\n*F\n+ 1 CityExpansionManager.kt\ncom/unciv/logic/city/managers/CityExpansionManager\n*L\n37#1:227,4\n69#1:231,2\n77#1:233,2\n119#1:235,14\n*E\n"})
public final class CityExpansionManager
implements IsPartOfGameInfoSerialization {
    public transient City city;
    private int cultureStored;

    @NotNull
    public final City getCity() {
        City city = this.city;
        if (city != null) {
            return city;
        }
        Intrinsics.throwUninitializedPropertyAccessException("city");
        return null;
    }

    public final void setCity(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "<set-?>");
        this.city = city;
    }

    public final int getCultureStored() {
        return this.cultureStored;
    }

    public final void setCultureStored(int n) {
        this.cultureStored = n;
    }

    @NotNull
    public final CityExpansionManager clone() {
        CityExpansionManager toReturn = new CityExpansionManager();
        toReturn.cultureStored = this.cultureStored;
        return toReturn;
    }

    @Readonly
    public final int tilesClaimed() {
        int n;
        Sequence<HexCoord> tilesAroundCity = SequencesKt.map(this.getCity().getCenterTile().getNeighbors(), CityExpansionManager::tilesClaimed$lambda$0);
        Iterable $this$count$iv = this.getCity().getTiles();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                HexCoord it = (HexCoord)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it, this.getCity().getLocation()) && !SequencesKt.contains(tilesAroundCity, it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    @Readonly
    public final int getCultureToNextTile() {
        double cultureToNextTile = (double)6 * Math.pow((double)Math.max(0, this.tilesClaimed()) + 1.4813, 1.3);
        cultureToNextTile *= (double)this.getCity().getCiv().getGameInfo().getSpeed().getCultureCostModifier();
        if (this.getCity().getCiv().isCityState()) {
            cultureToNextTile *= (double)1.5f;
        }
        Iterator iterator2 = City.getMatchingUniques$default(this.getCity(), UniqueType.BorderGrowthPercentage, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.getCity(), unique.getParams().get(1), null, false, 6, null)) continue;
            cultureToNextTile *= (double)FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return MathKt.roundToInt(cultureToNextTile);
    }

    @Readonly
    public final boolean canBuyTile(@NotNull Tile tile) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (this.getCity().isPuppet() || this.getCity().isBeingRazed()) {
                bl = false;
            } else if (tile.getOwner() != null) {
                bl = false;
            } else if (this.getCity().isInResistance()) {
                bl = false;
            } else if (!this.getCity().getTilesInRange().contains(tile)) {
                bl = false;
            } else {
                Sequence<Tile> $this$any$iv = tile.getNeighbors();
                boolean $i$f$any = false;
                Iterator<Tile> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getCity(), this.getCity())) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void buyTile(@NotNull Tile tile) {
        boolean bl;
        int goldCost;
        block3: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            goldCost = this.getGoldCostOfTile(tile);
            Sequence<Tile> $this$none$iv = tile.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getCity(), this.getCity())) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"com/unciv/logic/city/managers/CityExpansionManager$buyTile$TriedToBuyNonContiguousTileException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "<init>", "(Ljava/lang/String;)V", "core"})
            public final class TriedToBuyNonContiguousTileException
            extends Exception {
                public TriedToBuyNonContiguousTileException(String msg) {
                    Intrinsics.checkNotNullParameter(msg, "msg");
                    super(msg);
                }
            }
            throw new TriedToBuyNonContiguousTileException(this.getCity() + " tried to buy " + tile + ", but it owns none of the neighbors");
        }
        if (this.getCity().getCiv().getGold() < goldCost && !this.getCity().getCiv().getGameInfo().getGameParameters().getGodMode()) {
            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"com/unciv/logic/city/managers/CityExpansionManager$buyTile$NotEnoughGoldToBuyTileException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "<init>", "(Ljava/lang/String;)V", "core"})
            public final class NotEnoughGoldToBuyTileException
            extends Exception {
                public NotEnoughGoldToBuyTileException(String msg) {
                    Intrinsics.checkNotNullParameter(msg, "msg");
                    super(msg);
                }
            }
            throw new NotEnoughGoldToBuyTileException(this.getCity() + " tried to buy " + tile + ", but lacks gold (cost " + goldCost + ", has " + this.getCity().getCiv().getGold() + ')');
        }
        this.getCity().getCiv().addGold(-goldCost);
        this.takeOwnership(tile);
        this.getCity().reassignPopulationDeferred();
    }

    @Readonly
    public final int getGoldCostOfTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        int baseCost = 50;
        int distanceFromCenter = tile.aerialDistanceTo(this.getCity().getCenterTile());
        double cost = (double)(baseCost * (distanceFromCenter - 1)) + (double)this.tilesClaimed() * 5.0;
        cost *= (double)this.getCity().getCiv().getGameInfo().getSpeed().getGoldCostModifier();
        Iterator iterator2 = City.getMatchingUniques$default(this.getCity(), UniqueType.TileCostPercentage, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.getCity(), unique.getParams().get(1), null, false, 6, null)) continue;
            cost *= (double)FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return MathKt.roundToInt(cost);
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getChoosableTiles() {
        return SequencesKt.filter(this.getCity().getCenterTile().getTilesInDistance(this.getCity().getExpandRange()), CityExpansionManager::getChoosableTiles$lambda$0);
    }

    @Readonly
    @Nullable
    public final Tile chooseNewTileToOwn() {
        Tile tile;
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Sequence<Tile> $this$minByOrNull$iv = this.getChoosableTiles();
        boolean $i$f$minByOrNull = false;
        Iterator<Tile> iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            tile = null;
        } else {
            Tile minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                tile = minElem$iv;
            } else {
                Tile it = minElem$iv;
                boolean bl = false;
                int minValue$iv = Automation.INSTANCE.rankTileForExpansion$core(it, this.getCity(), localUniqueCache);
                do {
                    Tile e$iv;
                    Tile it2 = e$iv = iterator$iv.next();
                    $i$a$-minByOrNull-CityExpansionManager$chooseNewTileToOwn$1 = false;
                    int v$iv = Automation.INSTANCE.rankTileForExpansion$core(it2, this.getCity(), localUniqueCache);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                tile = minElem$iv;
            }
        }
        return tile;
    }

    public final void reset() {
        Tile tile;
        Iterator<Tile> iterator2 = this.getCity().getTiles().iterator();
        while (iterator2.hasNext()) {
            tile = iterator2.next();
            this.relinquishOwnership(tile);
        }
        this.takeOwnership(this.getCity().getCenterTile());
        iterator2 = SequencesKt.filter(this.getCity().getCenterTile().getTilesInDistance(1), CityExpansionManager::reset$lambda$0).iterator();
        while (iterator2.hasNext()) {
            tile = iterator2.next();
            this.takeOwnership(tile);
        }
    }

    private final Vector2 addNewTileWithCulture() {
        Tile chosenTile = this.chooseNewTileToOwn();
        if (chosenTile != null) {
            this.cultureStored -= this.getCultureToNextTile();
            this.takeOwnership(chosenTile);
            return chosenTile.getPosition().toVector2();
        }
        return null;
    }

    public final void relinquishOwnership(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.getCity().setTiles(CollectionExtensionsKt.withoutItem((Set)this.getCity().getTiles(), tile.getPosition()));
        for (City city : this.getCity().getCiv().getCities()) {
            if (!city.isWorked(tile)) continue;
            city.getPopulation().stopWorkingTile(tile.getPosition());
            city.getPopulation().autoAssignPopulation$core();
        }
        tile.getImprovementFunctions().removeCreatesOneImprovementMarker();
        tile.setOwningCity(null);
        this.getCity().getCiv().getCache().updateOurTiles();
        CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, false, 31, null);
        tile.getHistory().recordRelinquishOwnership(tile);
    }

    public final void takeOwnership(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!(!tile.isCityCenter())) {
            boolean $i$a$-check-CityExpansionManager$takeOwnership$22 = false;
            String $i$a$-check-CityExpansionManager$takeOwnership$22 = "Trying to found a city in a tile that already has one";
            throw new IllegalStateException($i$a$-check-CityExpansionManager$takeOwnership$22.toString());
        }
        if (tile.getCity() != null) {
            City city = tile.getCity();
            Intrinsics.checkNotNull(city);
            city.getExpansion().relinquishOwnership(tile);
        }
        this.getCity().setTiles(CollectionExtensionsKt.withItem((Set)this.getCity().getTiles(), tile.getPosition()));
        tile.setOwningCity(this.getCity());
        this.getCity().getPopulation().autoAssignPopulation$core();
        this.getCity().getCiv().getCache().updateOurTiles();
        CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, false, 31, null);
        for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
            if (!unit.getCiv().getDiplomacyFunctions().canPassThroughTiles(this.getCity().getCiv())) {
                unit.getMovement().teleportToClosestMoveableTile();
                continue;
            }
            if (!Intrinsics.areEqual(unit.getCiv(), this.getCity().getCiv()) || !unit.isSleeping() || !unit.getCache().getHasUniqueToBuildImprovements() && !unit.getCache().getHasUniqueToCreateWaterImprovements()) continue;
            unit.setDue(true);
            unit.setAction(null);
        }
        tile.getHistory().recordTakeOwnership(tile);
    }

    public final void nextTurn(float culture) {
        Vector2 location;
        this.cultureStored += (int)culture;
        if (this.cultureStored >= this.getCultureToNextTile() && (location = this.addNewTileWithCulture()) != null) {
            Object[] objectArray = new HexCoord[]{HexMathKt.toHexCoord(location), this.getCity().getLocation().toHexCoord()};
            Sequence<LocationAction> locations = LocationAction.Companion.invoke((HexCoord[])objectArray);
            objectArray = new String[]{"StatIcons/Culture"};
            this.getCity().getCiv().addNotification('[' + this.getCity().getName() + "] has expanded its borders!", locations, Notification.NotificationCategory.Cities, (String[])objectArray);
        }
    }

    public final void setTransients() {
        Sequence<Tile> tiles = this.getCity().getTiles();
        Iterator<Tile> iterator2 = tiles.iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            tile.setOwningCity(this.getCity());
        }
    }

    private static final HexCoord tilesClaimed$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition();
    }

    private static final boolean getChoosableTiles$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOwner() == null;
    }

    private static final boolean reset$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCity() == null;
    }
}

