/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.MissingModsException;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.files.MapSaver;
import com.unciv.logic.map.TileMap;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.LoadingPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorFilesScroll;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorLoadTab;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u001e\u001a\u00020\u0011*\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorLoadTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "headerHeight", "", "<init>", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;F)V", "mapFiles", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorFilesScroll;", "loadButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "deleteButton", "chosenMap", "Lcom/badlogic/gdx/files/FileHandle;", "loadHandler", "", "mapFile", "deleteHandler", "activated", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "deactivated", "selectFile", "file", "loaderThread", "Lkotlinx/coroutines/CoroutineScope;", "noMapsAvailable", "", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorLoadTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorLoadTab.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorLoadTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n295#2,2:162\n827#2:164\n855#2,2:165\n1#3:167\n*S KotlinDebug\n*F\n+ 1 MapEditorLoadTab.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorLoadTab\n*L\n111#1:162,2\n118#1:164\n118#1:165,2\n*E\n"})
public final class MapEditorLoadTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final MapEditorFilesScroll mapFiles;
    @NotNull
    private final TextButton loadButton;
    @NotNull
    private final TextButton deleteButton;
    @Nullable
    private FileHandle chosenMap;

    public MapEditorLoadTab(@NotNull MapEditorScreen editorScreen, float headerHeight) {
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        this.mapFiles = new MapEditorFilesScroll(this.editorScreen.getToolsWidth() - 20.0f, true, (Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            public final void invoke(FileHandle p0) {
                MapEditorLoadTab.access$selectFile((MapEditorLoadTab)this.receiver, p0);
            }
        }, (Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            public final void invoke(FileHandle p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                MapEditorLoadTab.access$loadHandler((MapEditorLoadTab)this.receiver, p0);
            }
        });
        this.loadButton = Scene2dExtensionsKt.toTextButton$default("Load map", null, false, 3, null);
        this.deleteButton = Scene2dExtensionsKt.toTextButton$default("Delete map", null, false, 3, null);
        Table buttonTable = new Table(this.getSkin());
        buttonTable.defaults().pad(10.0f).fillX();
        ActivationExtensionsKt.onActivation(this.loadButton, () -> MapEditorLoadTab._init_$lambda$0(this));
        ActivationExtensionsKt.getKeyShortcuts(this.loadButton).add(KeyCharAndCode.Companion.getRETURN());
        buttonTable.add((Actor)this.loadButton);
        ActivationExtensionsKt.onActivation(this.deleteButton, () -> MapEditorLoadTab._init_$lambda$1(this));
        ActivationExtensionsKt.getKeyShortcuts(this.deleteButton).add(KeyCharAndCode.Companion.getDEL());
        buttonTable.add((Actor)this.deleteButton);
        buttonTable.pack();
        float fileTableHeight = this.editorScreen.getStage().getHeight() - headerHeight - buttonTable.getHeight() - 2.0f;
        this.add((Actor)this.mapFiles).size(this.editorScreen.getToolsWidth() - 20.0f, fileTableHeight).padTop(10.0f).row();
        this.add((Actor)buttonTable).row();
    }

    private final void loadHandler(FileHandle mapFile) {
        this.editorScreen.askIfDirtyForLoad(() -> MapEditorLoadTab.loadHandler$lambda$0(this, mapFile));
    }

    private final void deleteHandler() {
        if (this.chosenMap == null) {
            return;
        }
        Popup.open$default(new ConfirmPopup(this.editorScreen, "Are you sure you want to delete this map?", "Delete map", false, null, () -> MapEditorLoadTab.deleteHandler$lambda$0(this), 24, null), false, 1, null);
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(true);
        MapEditorScreen.enableKeyboardPanningListener$core$default(this.editorScreen, null, false, 1, null);
        this.mapFiles.updateMaps();
        this.selectFile(null);
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        MapEditorScreen.enableKeyboardPanningListener$core$default(this.editorScreen, null, true, 1, null);
        pager.setScrollDisabled(false);
    }

    private final void selectFile(FileHandle file) {
        this.chosenMap = file;
        Scene2dExtensionsKt.setEnabled(this.loadButton, file != null);
        Scene2dExtensionsKt.setEnabled(this.deleteButton, file != null);
        this.deleteButton.setColor(file != null ? Color.SCARLET : Color.BROWN);
    }

    /*
     * WARNING - void declaration
     */
    private final void loaderThread(CoroutineScope $this$loaderThread, FileHandle mapFile) {
        Ref.ObjectRef<Popup> popup2 = new Ref.ObjectRef<Popup>();
        Ref.BooleanRef needPopup = new Ref.BooleanRef();
        needPopup.element = true;
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(needPopup, popup2, this, null){
            int label;
            final /* synthetic */ Ref.BooleanRef $needPopup;
            final /* synthetic */ Ref.ObjectRef<Popup> $popup;
            final /* synthetic */ MapEditorLoadTab this$0;
            {
                this.$needPopup = $needPopup;
                this.$popup = $popup;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        if (!this.$needPopup.element) {
                            return Unit.INSTANCE;
                        }
                        this.$popup.element = new LoadingPopup(MapEditorLoadTab.access$getEditorScreen$p(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        try {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Object v2;
            Object element$iv2;
            TileMap map2;
            block7: {
                map2 = MapSaver.INSTANCE.loadMap(mapFile);
                if (!CoroutineScopeKt.isActive($this$loaderThread)) {
                    return;
                }
                Iterable $this$firstOrNull$iv = map2.getMapParameters().getMods();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    String it = (String)element$iv2;
                    boolean bl = false;
                    Object object = (Ruleset)RulesetCache.INSTANCE.get((Object)it);
                    boolean bl2 = object != null && (object = ((Ruleset)object).getModOptions()) != null ? ((ModOptions)object).isBaseRuleset() : false;
                    if (!bl2) continue;
                    v2 = element$iv2;
                    break block7;
                }
                v2 = null;
            }
            String modBaseRuleset = v2;
            if (modBaseRuleset != null) {
                map2.getMapParameters().setBaseRuleset(modBaseRuleset);
                ((Collection)map2.getMapParameters().getMods()).remove(modBaseRuleset);
            }
            Iterable $i$f$firstOrNull = SetsKt.plus(SetsKt.setOf(map2.getMapParameters().getBaseRuleset()), (Iterable)map2.getMapParameters().getMods());
            boolean $i$f$filterNot = false;
            element$iv2 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((Map)RulesetCache.INSTANCE).containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List missingMods = (List)destination$iv$iv;
            if (!((Collection)missingMods).isEmpty()) {
                throw new MissingModsException(missingMods);
            }
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(map2, this, needPopup, popup2, mapFile, null){
                int label;
                final /* synthetic */ TileMap $map;
                final /* synthetic */ MapEditorLoadTab this$0;
                final /* synthetic */ Ref.BooleanRef $needPopup;
                final /* synthetic */ Ref.ObjectRef<Popup> $popup;
                final /* synthetic */ FileHandle $mapFile;
                {
                    this.$map = $map;
                    this.this$0 = $receiver;
                    this.$needPopup = $needPopup;
                    this.$popup = $popup;
                    this.$mapFile = $mapFile;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            Gdx.input.setInputProcessor(null);
                            try {
                                Ruleset ruleset = RulesetCache.INSTANCE.getComplexRuleset(this.$map.getMapParameters());
                                HashSet<String> rulesetIncompatibilities = this.$map.getRulesetIncompatibility(ruleset);
                                if (!((Collection)rulesetIncompatibilities).isEmpty()) {
                                    this.$map.removeMissingTerrainModReferences(ruleset);
                                    String message = "{This map has errors:}\n\n" + CollectionsKt.joinToString$default(CollectionsKt.sorted((Iterable)rulesetIncompatibilities), "\n", null, null, 0, null, loaderThread.2::invokeSuspend$lambda$0, 30, null) + "\n\n{The incompatible elements have been removed.}";
                                    new ToastPopup(message, MapEditorLoadTab.access$getEditorScreen$p(this.this$0), 4000L);
                                }
                                MapEditorScreen.loadMap$default(MapEditorLoadTab.access$getEditorScreen$p(this.this$0), this.$map, ruleset, 0, 4, null);
                                this.$needPopup.element = false;
                                Popup popup2 = (Popup)this.$popup.element;
                                if (popup2 != null) {
                                    popup2.close();
                                }
                            }
                            catch (Throwable ex) {
                                this.$needPopup.element = false;
                                Popup popup3 = (Popup)this.$popup.element;
                                if (popup3 != null) {
                                    popup3.close();
                                }
                                Log.INSTANCE.error("Error displaying map \"" + this.$mapFile + '\"', ex);
                                Gdx.input.setInputProcessor(MapEditorLoadTab.access$getEditorScreen$p(this.this$0).getStage());
                                new ToastPopup("Error loading map!", MapEditorLoadTab.access$getEditorScreen$p(this.this$0), 0L, 4, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final CharSequence invokeSuspend$lambda$0(String it) {
                    return TranslationsKt.tr$default(it, false, false, 3, null);
                }
            }, 1, null);
        }
        catch (Throwable ex) {
            needPopup.element = false;
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(popup2, mapFile, ex, this, null){
                int label;
                final /* synthetic */ Ref.ObjectRef<Popup> $popup;
                final /* synthetic */ FileHandle $mapFile;
                final /* synthetic */ Throwable $ex;
                final /* synthetic */ MapEditorLoadTab this$0;
                {
                    this.$popup = $popup;
                    this.$mapFile = $mapFile;
                    this.$ex = $ex;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            Popup popup2 = (Popup)this.$popup.element;
                            if (popup2 != null) {
                                popup2.close();
                            }
                            Log.INSTANCE.error("Error loading map \"" + this.$mapFile + '\"', this.$ex);
                            new ToastPopup("{Error loading map!}" + (this.$ex instanceof UncivShowableException ? "\n{" + ((UncivShowableException)this.$ex).getMessage() + '}' : ""), MapEditorLoadTab.access$getEditorScreen$p(this.this$0), 0L, 4, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    public final boolean noMapsAvailable() {
        return this.mapFiles.noMapsAvailable();
    }

    private static final Unit _init_$lambda$0(MapEditorLoadTab this$0) {
        block0: {
            FileHandle fileHandle = this$0.chosenMap;
            if (fileHandle == null) break block0;
            FileHandle it = fileHandle;
            boolean bl = false;
            this$0.loadHandler(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MapEditorLoadTab this$0) {
        this$0.deleteHandler();
        return Unit.INSTANCE;
    }

    private static final Unit loadHandler$lambda$0(MapEditorLoadTab this$0, FileHandle $mapFile) {
        MapEditorScreen.startBackgroundJob$default(this$0.editorScreen, "MapLoader", false, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $mapFile, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapEditorLoadTab this$0;
            final /* synthetic */ FileHandle $mapFile;
            {
                this.this$0 = $receiver;
                this.$mapFile = $mapFile;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$startBackgroundJob;
                        ResultKt.throwOnFailure($result);
                        MapEditorLoadTab.access$loaderThread(this.this$0, (CoroutineScope)$this$startBackgroundJob, this.$mapFile);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit deleteHandler$lambda$0(MapEditorLoadTab this$0) {
        FileHandle fileHandle = this$0.chosenMap;
        Intrinsics.checkNotNull(fileHandle);
        fileHandle.delete();
        this$0.mapFiles.updateMaps();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MapEditorScreen access$getEditorScreen$p(MapEditorLoadTab $this) {
        return $this.editorScreen;
    }

    public static final /* synthetic */ void access$loaderThread(MapEditorLoadTab $this, CoroutineScope $receiver, FileHandle mapFile) {
        $this.loaderThread($receiver, mapFile);
    }

    public static final /* synthetic */ void access$selectFile(MapEditorLoadTab $this, FileHandle file) {
        $this.selectFile(file);
    }

    public static final /* synthetic */ void access$loadHandler(MapEditorLoadTab $this, FileHandle mapFile) {
        $this.loadHandler(mapFile);
    }
}

