/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import com.badlogic.gdx.Gdx;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.CompatibilityVersion;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.HasGameInfoSerializationVersion;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.MissingModsException;
import com.unciv.logic.VictoryData;
import com.unciv.logic.automation.civilization.BarbarianManager;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.managers.TurnManager;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.github.Github;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.GlobalUniques;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.screens.savescreens.Gzip;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.status.NextTurnProgress;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.utils.DebugUtils;
import com.unciv.utils.LogKt;
import java.security.MessageDigest;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0007\u0010\u0087\u0001\u001a\u00020\u0000J\u0007\u0010\u0088\u0001\u001a\u00020\rJ\u0012\u0010\u008f\u0001\u001a\u00020\r2\u0007\u0010\u0090\u0001\u001a\u00020\u001aH\u0007J\u0014\u0010\u0091\u0001\u001a\u0004\u0018\u00010\r2\u0007\u0010\u0090\u0001\u001a\u00020\u001aH\u0007J\u0007\u0010\u0092\u0001\u001a\u00020\rJ\u000f\u0010\u0093\u0001\u001a\n\u0012\u0005\u0012\u00030\u0095\u00010\u0094\u0001J\t\u0010\u0096\u0001\u001a\u00020\rH\u0007J\b\u0010!\u001a\u00020eH\u0007J\t\u0010\u0097\u0001\u001a\u00020mH\u0007J\u0011\u0010\u0098\u0001\u001a\n\u0012\u0005\u0012\u00030\u009a\u00010\u0099\u0001H\u0007J\u0010\u0010\u009b\u0001\u001a\t\u0012\u0004\u0012\u00020\r0\u009c\u0001H\u0007J\u0010\u0010\u009d\u0001\u001a\t\u0012\u0004\u0012\u00020\r0\u009c\u0001H\u0007JK\u0010\u009e\u0001\u001a\t\u0012\u0004\u0012\u00020\r0\u0099\u00012\t\b\u0002\u0010\u009f\u0001\u001a\u0002082\t\b\u0002\u0010\u00a0\u0001\u001a\u0002082\u000b\b\u0002\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\r2\u0018\b\u0002\u0010\u00a2\u0001\u001a\u0011\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000208\u0018\u00010\u00a3\u0001J\u0010\u0010\u00a4\u0001\u001a\u00020\r2\u0007\u0010\u00a5\u0001\u001a\u00020\u001aJ\u0012\u0010\u00a6\u0001\u001a\u00020\r2\u0007\u0010\u00a5\u0001\u001a\u00020\u001aH\u0002J\t\u0010\u00a7\u0001\u001a\u000208H\u0007J\t\u0010\u00a8\u0001\u001a\u000208H\u0007J\t\u0010\u00a9\u0001\u001a\u000202H\u0003J\u0014\u0010\u00aa\u0001\u001a\u0002022\t\b\u0002\u0010\u00ab\u0001\u001a\u000202H\u0007J\u0007\u0010\u00ac\u0001\u001a\u00020\u001aJ\t\u0010\u00ad\u0001\u001a\u000208H\u0007J\u0016\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\f\b\u0002\u0010\u00b0\u0001\u001a\u0005\u0018\u00010\u00b1\u0001J\u0013\u0010\u00b2\u0001\u001a\u00030\u00af\u00012\u0007\u0010\u00b3\u0001\u001a\u00020\rH\u0002J\u0017\u0010\u00b4\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0005\u0012\u00030\u00b5\u00010\u008a\u0001H\u0007J\b\u0010\u00b6\u0001\u001a\u00030\u00af\u0001J\u0007\u0010\u00b7\u0001\u001a\u000208J-\u0010\u00b8\u0001\u001a\u00030\u00af\u00012\u0007\u0010\u00b3\u0001\u001a\u00020\r2\u000f\u0010\u00b9\u0001\u001a\n\u0012\u0005\u0012\u00030\u00ba\u00010\u009c\u00012\u0007\u0010\u00bb\u0001\u001a\u00020\u001aH\u0002J$\u0010\u00bc\u0001\u001a\u00030\u00af\u00012\u0007\u0010\u00b3\u0001\u001a\u00020\r2\u000f\u0010\u00bd\u0001\u001a\n\u0012\u0005\u0012\u00030\u009a\u00010\u009c\u0001H\u0002J=\u0010\u00be\u0001\u001a\u0002082\u0007\u0010\u00bf\u0001\u001a\u00020\r2\u0007\u0010\u00c0\u0001\u001a\u00020\u001a2\t\b\u0002\u0010\u00c1\u0001\u001a\u0002022\u0017\b\u0002\u0010\u00c2\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u00ba\u0001\u0012\u0004\u0012\u0002080\u00a3\u0001J@\u0010\u00c3\u0001\u001a\u0005\u0018\u00010\u00c4\u00012\u0007\u0010\u00c5\u0001\u001a\u00020\r2\u0007\u0010\u00c0\u0001\u001a\u00020\u001a2\t\b\u0002\u0010\u00c1\u0001\u001a\u0002022\u0017\b\u0002\u0010\u00c2\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u00ba\u0001\u0012\u0004\u0012\u0002080\u00a3\u0001J\b\u0010\u00c6\u0001\u001a\u00030\u00af\u0001J\b\u0010\u00c7\u0001\u001a\u00030\u00af\u0001J\n\u0010\u00c8\u0001\u001a\u00030\u00af\u0001H\u0002J\n\u0010\u00c9\u0001\u001a\u00030\u00af\u0001H\u0002J\n\u0010\u00ca\u0001\u001a\u00030\u00cb\u0001H\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R&\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\"\"\u0004\b?\u0010$R\u001a\u0010@\u001a\u00020AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001a\u0010F\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\"\"\u0004\bH\u0010$R\u001a\u0010I\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\"\"\u0004\bK\u0010$R\u001a\u0010L\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u00104\"\u0004\bN\u00106R\u001c\u0010O\u001a\u0004\u0018\u00010PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR(\u0010U\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u001d\"\u0004\bW\u0010\u001fR\u001a\u0010X\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010:\"\u0004\bZ\u0010<R\u001a\u0010[\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u00104\"\u0004\b]\u00106R\u001c\u0010^\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\"\"\u0004\b`\u0010$R \u0010a\u001a\b\u0012\u0004\u0012\u00020\u001a0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\u000f\"\u0004\bc\u0010\u0011R\u000e\u0010d\u001a\u00020eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010f\u001a\u00020gX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u000e\u0010l\u001a\u00020mX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010n\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010p\"\u0004\bq\u0010rR\u001a\u0010s\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010:\"\u0004\bt\u0010<R\u001a\u0010u\u001a\u00020vX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\u001a\u0010{\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u00104\"\u0004\b}\u00106R\u001b\u0010~\u001a\u000208X\u0086\u000e\u00a2\u0006\u000f\n\u0000\u001a\u0004\b\u007f\u0010:\"\u0005\b\u0080\u0001\u0010<R&\u0010\u0081\u0001\u001a\t\u0012\u0004\u0012\u00020\u001a0\u0082\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001\"\u0006\b\u0085\u0001\u0010\u0086\u0001R-\u0010\u0089\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\r0\u008a\u00018FX\u0086\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u008d\u0001\u0010\u008e\u0001\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001\u00a8\u0006\u00cc\u0001"}, d2={"Lcom/unciv/logic/GameInfo;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "Lcom/unciv/logic/HasGameInfoSerializationVersion;", "<init>", "()V", "version", "Lcom/unciv/logic/CompatibilityVersion;", "getVersion", "()Lcom/unciv/logic/CompatibilityVersion;", "setVersion", "(Lcom/unciv/logic/CompatibilityVersion;)V", "civilizations", "Ljava/util/ArrayList;", "Lcom/unciv/logic/civilization/Civilization;", "getCivilizations", "()Ljava/util/ArrayList;", "setCivilizations", "(Ljava/util/ArrayList;)V", "barbarians", "Lcom/unciv/logic/automation/civilization/BarbarianManager;", "getBarbarians", "()Lcom/unciv/logic/automation/civilization/BarbarianManager;", "setBarbarians", "(Lcom/unciv/logic/automation/civilization/BarbarianManager;)V", "religions", "Ljava/util/HashMap;", "", "Lcom/unciv/models/Religion;", "getReligions", "()Ljava/util/HashMap;", "setReligions", "(Ljava/util/HashMap;)V", "difficulty", "getDifficulty", "()Ljava/lang/String;", "setDifficulty", "(Ljava/lang/String;)V", "tileMap", "Lcom/unciv/logic/map/TileMap;", "getTileMap", "()Lcom/unciv/logic/map/TileMap;", "setTileMap", "(Lcom/unciv/logic/map/TileMap;)V", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "getGameParameters", "()Lcom/unciv/models/metadata/GameParameters;", "setGameParameters", "(Lcom/unciv/models/metadata/GameParameters;)V", "turns", "", "getTurns", "()I", "setTurns", "(I)V", "oneMoreTurnMode", "", "getOneMoreTurnMode", "()Z", "setOneMoreTurnMode", "(Z)V", "currentPlayer", "getCurrentPlayer", "setCurrentPlayer", "currentTurnStartTime", "", "getCurrentTurnStartTime", "()J", "setCurrentTurnStartTime", "(J)V", "gameId", "getGameId", "setGameId", "checksum", "getChecksum", "setChecksum", "lastUnitId", "getLastUnitId", "setLastUnitId", "victoryData", "Lcom/unciv/logic/VictoryData;", "getVictoryData", "()Lcom/unciv/logic/VictoryData;", "setVictoryData", "(Lcom/unciv/logic/VictoryData;)V", "diplomaticVictoryVotesCast", "getDiplomaticVictoryVotesCast", "setDiplomaticVictoryVotesCast", "diplomaticVictoryVotesProcessed", "getDiplomaticVictoryVotesProcessed", "setDiplomaticVictoryVotesProcessed", "historyStartTurn", "getHistoryStartTurn", "setHistoryStartTurn", "customSaveLocation", "getCustomSaveLocation", "setCustomSaveLocation", "unitNamesTaken", "getUnitNamesTaken", "setUnitNamesTaken", "difficultyObject", "Lcom/unciv/models/ruleset/nation/Difficulty;", "speed", "Lcom/unciv/models/ruleset/Speed;", "getSpeed", "()Lcom/unciv/models/ruleset/Speed;", "setSpeed", "(Lcom/unciv/models/ruleset/Speed;)V", "combinedGlobalUniques", "Lcom/unciv/models/ruleset/GlobalUniques;", "currentPlayerCiv", "getCurrentPlayerCiv", "()Lcom/unciv/logic/civilization/Civilization;", "setCurrentPlayerCiv", "(Lcom/unciv/logic/civilization/Civilization;)V", "isUpToDate", "setUpToDate", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "setRuleset", "(Lcom/unciv/models/ruleset/Ruleset;)V", "simulateMaxTurns", "getSimulateMaxTurns", "setSimulateMaxTurns", "simulateUntilWin", "getSimulateUntilWin", "setSimulateUntilWin", "spaceResources", "Ljava/util/HashSet;", "getSpaceResources", "()Ljava/util/HashSet;", "setSpaceResources", "(Ljava/util/HashSet;)V", "clone", "getPlayerToViewAs", "civMap", "", "getCivMap", "()Ljava/util/Map;", "civMap$delegate", "Lkotlin/Lazy;", "getCivilization", "civID", "getCivilizationOrNull", "getCurrentPlayerCivilization", "getCivilizationsAsPreviews", "", "Lcom/unciv/logic/civilization/CivilizationInfoPreview;", "getBarbarianCivilization", "getGlobalUniques", "getCities", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/city/City;", "getAliveCityStates", "", "getAliveMajorCivs", "getCivsSorted", "includeCityStates", "includeDefeated", "civToSortFirst", "additionalFilter", "Lkotlin/Function1;", "getSpectator", "playerId", "createTemporarySpectatorCiv", "isReligionEnabled", "isEspionageEnabled", "getEquivalentTurn", "getYear", "turnOffset", "calculateChecksum", "isSimulation", "nextTurn", "", "progressBar", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnProgress;", "notifyOfCloseEnemyUnits", "thisPlayer", "getEnabledVictories", "Lcom/unciv/models/ruleset/Victory;", "processDiplomaticVictory", "checkForVictory", "addEnemyUnitNotification", "tiles", "Lcom/unciv/logic/map/tile/Tile;", "inOrNear", "addBombardNotification", "cities", "notifyExploredResources", "civInfo", "resourceName", "maxDistance", "filter", "getExploredResourcesNotification", "Lcom/unciv/logic/civilization/Notification;", "civ", "setTransients", "setGlobalTransients", "updateCivilizationState", "convertOldSavesToNewSaves", "asPreview", "Lcom/unciv/logic/GameInfoPreview;", "core"})
@SourceDebugExtension(value={"SMAP\nGameInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameInfo.kt\ncom/unciv/logic/GameInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,813:1\n1761#2,3:814\n1563#2:817\n1634#2,3:818\n230#2,2:821\n295#2,2:823\n1563#2:825\n1634#2,3:826\n774#2:829\n865#2,2:830\n774#2:832\n865#2,2:833\n295#2,2:835\n1563#2:837\n1634#2,3:838\n774#2:841\n865#2:842\n866#2:845\n774#2:846\n865#2,2:847\n774#2:849\n865#2,2:850\n774#2:852\n865#2:853\n1761#2,3:854\n866#2:857\n1563#2:865\n1634#2,3:866\n827#2:869\n855#2,2:870\n1491#2:873\n1516#2,3:874\n1519#2,3:884\n230#2,2:887\n230#2,2:889\n774#2:891\n865#2,2:892\n1374#2:894\n1460#2,5:895\n1374#2:900\n1460#2,5:901\n295#2,2:907\n774#2:909\n865#2,2:910\n1208#2,2:912\n1236#2,4:914\n1761#2,3:918\n230#2,2:921\n1761#2,3:923\n230#2,2:926\n1255#3,2:843\n622#3:906\n536#4:858\n521#4,6:859\n382#4,7:877\n1#5:872\n*S KotlinDebug\n*F\n+ 1 GameInfo.kt\ncom/unciv/logic/GameInfo\n*L\n209#1:814,3\n210#1:817\n210#1:818,3\n228#1:821,2\n232#1:823,2\n235#1:825\n235#1:826,3\n246#1:829\n246#1:830,2\n247#1:832\n247#1:833,2\n280#1:835,2\n439#1:837\n439#1:838,3\n441#1:841\n441#1:842\n441#1:845\n451#1:846\n451#1:847,2\n457#1:849\n457#1:850,2\n463#1:852\n463#1:853\n465#1:854,3\n463#1:857\n618#1:865\n618#1:866,3\n642#1:869\n642#1:870,2\n679#1:873\n679#1:874,3\n679#1:884,3\n684#1:887,2\n685#1:889,2\n701#1:891\n701#1:892,2\n702#1:894\n702#1:895,5\n703#1:900\n703#1:901,5\n769#1:907,2\n772#1:909\n772#1:910,2\n223#1:912,2\n223#1:914,4\n368#1:918,3\n369#1:921,2\n376#1:923,3\n377#1:926,2\n444#1:843,2\n725#1:906\n470#1:858\n470#1:859,6\n679#1:877,7\n*E\n"})
public final class GameInfo
implements IsPartOfGameInfoSerialization,
HasGameInfoSerializationVersion {
    @NotNull
    private CompatibilityVersion version = CompatibilityVersion.Companion.getFIRST_WITHOUT();
    @NotNull
    private ArrayList<Civilization> civilizations = new ArrayList();
    @NotNull
    private BarbarianManager barbarians = new BarbarianManager();
    @NotNull
    private HashMap<String, Religion> religions = new HashMap();
    @NotNull
    private String difficulty = "Chieftain";
    @NotNull
    private TileMap tileMap = new TileMap(0, 1, null);
    @NotNull
    private GameParameters gameParameters = new GameParameters();
    private int turns;
    private boolean oneMoreTurnMode;
    @NotNull
    private String currentPlayer = "";
    private long currentTurnStartTime = System.currentTimeMillis();
    @NotNull
    private String gameId;
    @NotNull
    private String checksum;
    private int lastUnitId;
    @Nullable
    private VictoryData victoryData;
    @NotNull
    private HashMap<String, String> diplomaticVictoryVotesCast;
    private boolean diplomaticVictoryVotesProcessed;
    private int historyStartTurn;
    @Nullable
    private volatile String customSaveLocation;
    @NotNull
    private ArrayList<String> unitNamesTaken;
    private transient Difficulty difficultyObject;
    public transient Speed speed;
    private transient GlobalUniques combinedGlobalUniques;
    public transient Civilization currentPlayerCiv;
    private transient boolean isUpToDate;
    public transient Ruleset ruleset;
    private transient int simulateMaxTurns;
    private transient boolean simulateUntilWin;
    @NotNull
    private transient HashSet<String> spaceResources;
    @NotNull
    private final transient Lazy civMap$delegate;

    public GameInfo() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.gameId = string;
        this.checksum = "";
        this.diplomaticVictoryVotesCast = new HashMap();
        this.historyStartTurn = -1;
        this.unitNamesTaken = new ArrayList();
        this.simulateMaxTurns = 1000;
        this.spaceResources = new HashSet();
        this.civMap$delegate = LazyKt.lazy(() -> GameInfo.civMap_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public CompatibilityVersion getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull CompatibilityVersion compatibilityVersion) {
        Intrinsics.checkNotNullParameter(compatibilityVersion, "<set-?>");
        this.version = compatibilityVersion;
    }

    @NotNull
    public final ArrayList<Civilization> getCivilizations() {
        return this.civilizations;
    }

    public final void setCivilizations(@NotNull ArrayList<Civilization> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.civilizations = arrayList;
    }

    @NotNull
    public final BarbarianManager getBarbarians() {
        return this.barbarians;
    }

    public final void setBarbarians(@NotNull BarbarianManager barbarianManager) {
        Intrinsics.checkNotNullParameter(barbarianManager, "<set-?>");
        this.barbarians = barbarianManager;
    }

    @NotNull
    public final HashMap<String, Religion> getReligions() {
        return this.religions;
    }

    public final void setReligions(@NotNull HashMap<String, Religion> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.religions = hashMap;
    }

    @NotNull
    public final String getDifficulty() {
        return this.difficulty;
    }

    public final void setDifficulty(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.difficulty = string;
    }

    @NotNull
    public final TileMap getTileMap() {
        return this.tileMap;
    }

    public final void setTileMap(@NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(tileMap, "<set-?>");
        this.tileMap = tileMap;
    }

    @NotNull
    public final GameParameters getGameParameters() {
        return this.gameParameters;
    }

    public final void setGameParameters(@NotNull GameParameters gameParameters) {
        Intrinsics.checkNotNullParameter(gameParameters, "<set-?>");
        this.gameParameters = gameParameters;
    }

    public final int getTurns() {
        return this.turns;
    }

    public final void setTurns(int n) {
        this.turns = n;
    }

    public final boolean getOneMoreTurnMode() {
        return this.oneMoreTurnMode;
    }

    public final void setOneMoreTurnMode(boolean bl) {
        this.oneMoreTurnMode = bl;
    }

    @NotNull
    public final String getCurrentPlayer() {
        return this.currentPlayer;
    }

    public final void setCurrentPlayer(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.currentPlayer = string;
    }

    public final long getCurrentTurnStartTime() {
        return this.currentTurnStartTime;
    }

    public final void setCurrentTurnStartTime(long l) {
        this.currentTurnStartTime = l;
    }

    @NotNull
    public final String getGameId() {
        return this.gameId;
    }

    public final void setGameId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.gameId = string;
    }

    @NotNull
    public final String getChecksum() {
        return this.checksum;
    }

    public final void setChecksum(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.checksum = string;
    }

    public final int getLastUnitId() {
        return this.lastUnitId;
    }

    public final void setLastUnitId(int n) {
        this.lastUnitId = n;
    }

    @Nullable
    public final VictoryData getVictoryData() {
        return this.victoryData;
    }

    public final void setVictoryData(@Nullable VictoryData victoryData) {
        this.victoryData = victoryData;
    }

    @NotNull
    public final HashMap<String, String> getDiplomaticVictoryVotesCast() {
        return this.diplomaticVictoryVotesCast;
    }

    public final void setDiplomaticVictoryVotesCast(@NotNull HashMap<String, String> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.diplomaticVictoryVotesCast = hashMap;
    }

    public final boolean getDiplomaticVictoryVotesProcessed() {
        return this.diplomaticVictoryVotesProcessed;
    }

    public final void setDiplomaticVictoryVotesProcessed(boolean bl) {
        this.diplomaticVictoryVotesProcessed = bl;
    }

    public final int getHistoryStartTurn() {
        return this.historyStartTurn;
    }

    public final void setHistoryStartTurn(int n) {
        this.historyStartTurn = n;
    }

    @Nullable
    public final String getCustomSaveLocation() {
        return this.customSaveLocation;
    }

    public final void setCustomSaveLocation(@Nullable String string) {
        this.customSaveLocation = string;
    }

    @NotNull
    public final ArrayList<String> getUnitNamesTaken() {
        return this.unitNamesTaken;
    }

    public final void setUnitNamesTaken(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.unitNamesTaken = arrayList;
    }

    @NotNull
    public final Speed getSpeed() {
        Speed speed = this.speed;
        if (speed != null) {
            return speed;
        }
        Intrinsics.throwUninitializedPropertyAccessException("speed");
        return null;
    }

    public final void setSpeed(@NotNull Speed speed) {
        Intrinsics.checkNotNullParameter(speed, "<set-?>");
        this.speed = speed;
    }

    @NotNull
    public final Civilization getCurrentPlayerCiv() {
        Civilization civilization = this.currentPlayerCiv;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("currentPlayerCiv");
        return null;
    }

    public final void setCurrentPlayerCiv(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.currentPlayerCiv = civilization;
    }

    public final boolean isUpToDate() {
        return this.isUpToDate;
    }

    public final void setUpToDate(boolean bl) {
        this.isUpToDate = bl;
    }

    @NotNull
    public final Ruleset getRuleset() {
        Ruleset ruleset = this.ruleset;
        if (ruleset != null) {
            return ruleset;
        }
        Intrinsics.throwUninitializedPropertyAccessException("ruleset");
        return null;
    }

    public final void setRuleset(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "<set-?>");
        this.ruleset = ruleset;
    }

    public final int getSimulateMaxTurns() {
        return this.simulateMaxTurns;
    }

    public final void setSimulateMaxTurns(int n) {
        this.simulateMaxTurns = n;
    }

    public final boolean getSimulateUntilWin() {
        return this.simulateUntilWin;
    }

    public final void setSimulateUntilWin(boolean bl) {
        this.simulateUntilWin = bl;
    }

    @NotNull
    public final HashSet<String> getSpaceResources() {
        return this.spaceResources;
    }

    public final void setSpaceResources(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.spaceResources = hashSet;
    }

    @NotNull
    public final GameInfo clone() {
        GameInfo toReturn = new GameInfo();
        toReturn.tileMap = this.tileMap.clone();
        toReturn.civilizations = (ArrayList)SequencesKt.toCollection(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.civilizations), GameInfo::clone$lambda$0), (Collection)new ArrayList(this.civilizations.size()));
        toReturn.barbarians = this.barbarians.clone();
        MapsKt.putAll((Map)toReturn.religions, SequencesKt.map(MapsKt.asSequence((Map)this.religions), GameInfo::clone$lambda$1));
        toReturn.currentPlayer = this.currentPlayer;
        toReturn.currentTurnStartTime = this.currentTurnStartTime;
        toReturn.turns = this.turns;
        toReturn.difficulty = this.difficulty;
        toReturn.gameParameters = this.gameParameters;
        toReturn.gameId = this.gameId;
        toReturn.diplomaticVictoryVotesCast.putAll((Map<String, String>)this.diplomaticVictoryVotesCast);
        toReturn.oneMoreTurnMode = this.oneMoreTurnMode;
        toReturn.customSaveLocation = this.customSaveLocation;
        VictoryData victoryData = this.victoryData;
        toReturn.victoryData = victoryData != null ? VictoryData.copy$default(victoryData, null, null, 0, 7, null) : null;
        toReturn.historyStartTurn = this.historyStartTurn;
        toReturn.lastUnitId = this.lastUnitId;
        toReturn.unitNamesTaken.addAll((Collection<String>)this.unitNamesTaken);
        return toReturn;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Civilization getPlayerToViewAs() {
        boolean bl;
        String userId;
        block8: {
            if (!this.gameParameters.isOnlineMultiplayer()) {
                return this.getCurrentPlayerCivilization();
            }
            userId = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId();
            Iterable $this$any$iv = this.civilizations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getPlayerId(), userId)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            Iterable $this$map$iv = this.civilizations;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Civilization civilization = (Civilization)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getCivID());
            }
            int civIndex = ((List)destination$iv$iv).indexOf(this.currentPlayer);
            while (true) {
                Civilization civToCheck;
                Intrinsics.checkNotNullExpressionValue(this.civilizations.get(civIndex % this.civilizations.size()), "get(...)");
                if (Intrinsics.areEqual(civToCheck.getPlayerId(), userId)) {
                    return civToCheck;
                }
                ++civIndex;
            }
        }
        return this.getSpectator(userId);
    }

    @NotNull
    public final Map<String, Civilization> getCivMap() {
        Lazy lazy = this.civMap$delegate;
        return (Map)lazy.getValue();
    }

    @Readonly
    @NotNull
    public final Civilization getCivilization(@NotNull String civID) {
        Intrinsics.checkNotNullParameter(civID, "civID");
        Civilization civilization = this.getCivMap().get(civID);
        if (civilization == null) {
            Object element$iv2;
            block2: {
                Iterable $this$first$iv = this.civilizations;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Civilization it = (Civilization)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getCivID(), civID)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            civilization = (Civilization)element$iv2;
        }
        return civilization;
    }

    @Readonly
    @Nullable
    public final Civilization getCivilizationOrNull(@NotNull String civID) {
        Intrinsics.checkNotNullParameter(civID, "civID");
        Civilization civilization = this.getCivMap().get(civID);
        if (civilization == null) {
            Object v1;
            block2: {
                Iterable $this$firstOrNull$iv = this.civilizations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getCivID(), civID)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            civilization = v1;
        }
        return civilization;
    }

    @NotNull
    public final Civilization getCurrentPlayerCivilization() {
        return this.getCurrentPlayerCiv();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CivilizationInfoPreview> getCivilizationsAsPreviews() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.civilizations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Civilization civilization = (Civilization)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asPreview());
        }
        return CollectionsKt.toMutableList((List)destination$iv$iv);
    }

    @Readonly
    @NotNull
    public final Civilization getBarbarianCivilization() {
        return this.getCivilization("Barbarians");
    }

    @Readonly
    @NotNull
    public final Difficulty getDifficulty() {
        Difficulty difficulty = this.difficultyObject;
        if (difficulty == null) {
            Intrinsics.throwUninitializedPropertyAccessException("difficultyObject");
            difficulty = null;
        }
        return difficulty;
    }

    @Readonly
    @NotNull
    public final GlobalUniques getGlobalUniques() {
        GlobalUniques globalUniques = this.combinedGlobalUniques;
        if (globalUniques == null) {
            Intrinsics.throwUninitializedPropertyAccessException("combinedGlobalUniques");
            globalUniques = null;
        }
        return globalUniques;
    }

    @Readonly
    @NotNull
    public final Sequence<City> getCities() {
        return SequencesKt.flatMapIterable(CollectionsKt.asSequence((Iterable)this.civilizations), GameInfo::getCities$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Civilization> getAliveCityStates() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.civilizations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isAlive() && it.isCityState())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Civilization> getAliveMajorCivs() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.civilizations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isAlive() && it.isMajorCiv())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Sequence<Civilization> getCivsSorted(boolean includeCityStates, boolean includeDefeated, @Nullable Civilization civToSortFirst, @Nullable Function1<? super Civilization, Boolean> additionalFilter) {
        Collator collator = GUI.INSTANCE.getSettings().getCollatorFromLocale();
        Comparator comparator = new Comparator(civToSortFirst){
            final /* synthetic */ Civilization $civToSortFirst$inlined;
            {
                this.$civToSortFirst$inlined = civilization;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)a;
                boolean bl = false;
                boolean bl2 = !Intrinsics.areEqual(it, this.$civToSortFirst$inlined);
                it = (Civilization)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it, this.$civToSortFirst$inlined));
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Civilization it = (Civilization)b;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.isMajorCiv());
                    it = (Civilization)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.isMajorCiv());
                }
                return n;
            }
        };
        return SequencesKt.sortedWith(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)this.civilizations), arg_0 -> GameInfo.getCivsSorted$lambda$0(includeDefeated, includeCityStates, additionalFilter, arg_0)), new Comparator(comparator, collator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Civilization civilization = (Civilization)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Civilization it = (Civilization)b;
                    String string = TranslationsKt.tr$default(it.getCivName(), true, false, 2, null);
                    bl = false;
                    String string2 = TranslationsKt.tr$default(it.getCivName(), true, false, 2, null);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        });
    }

    public static /* synthetic */ Sequence getCivsSorted$default(GameInfo gameInfo, boolean bl, boolean bl2, Civilization civilization, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            civilization = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return gameInfo.getCivsSorted(bl, bl2, civilization, function1);
    }

    @NotNull
    public final Civilization getSpectator(@NotNull String playerId) {
        Civilization gameSpectatorCiv;
        Civilization civilization;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Iterable $this$firstOrNull$iv = this.civilizations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!(it.isSpectator() && Intrinsics.areEqual(it.getPlayerId(), playerId))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((civilization = (gameSpectatorCiv = (Civilization)v0)) == null) {
            civilization = this.createTemporarySpectatorCiv(playerId);
        }
        return civilization;
    }

    private final Civilization createTemporarySpectatorCiv(String playerId) {
        Civilization civilization;
        Civilization it = civilization = new Civilization("Spectator");
        boolean bl = false;
        it.setPlayerType(PlayerType.Human);
        it.setPlayerId(playerId);
        this.civilizations.add(it);
        it.setGameInfo(this);
        it.setNationTransient();
        it.getCache().updateState();
        CivInfoTransientCache.updateViewableTiles$default(it.getCache(), null, 1, null);
        it.setTransients();
        return civilization;
    }

    @Readonly
    public final boolean isReligionEnabled() {
        Era era = this.getRuleset().getEras().get(this.gameParameters.getStartingEra());
        Intrinsics.checkNotNull(era);
        if (IHasUniques.hasUnique$default(era, UniqueType.DisablesReligion, null, 2, null)) {
            return false;
        }
        return !IHasUniques.hasUnique$default(this.getRuleset().getModOptions(), UniqueType.DisableReligion, null, 2, null);
    }

    @Readonly
    public final boolean isEspionageEnabled() {
        return this.gameParameters.getEspionageEnabled();
    }

    @Readonly
    private final int getEquivalentTurn() {
        int totalTurns = this.getSpeed().numTotalTurns();
        Era era = this.getRuleset().getEras().get(this.gameParameters.getStartingEra());
        Intrinsics.checkNotNull(era);
        int startPercent = era.getStartPercent();
        return this.turns + totalTurns * startPercent / 100;
    }

    @Readonly
    public final int getYear(int turnOffset) {
        return (int)this.getSpeed().turnToYear(this.getEquivalentTurn() + turnOffset);
    }

    public static /* synthetic */ int getYear$default(GameInfo gameInfo, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return gameInfo.getYear(n);
    }

    @NotNull
    public final String calculateChecksum() {
        String oldChecksum = this.checksum;
        this.checksum = "";
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        String string = UncivJsonKt.json().toJson(this);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] bytes = messageDigest.digest(byArray);
        this.checksum = oldChecksum;
        Intrinsics.checkNotNull(bytes);
        return Gzip.INSTANCE.encode(bytes);
    }

    @Readonly
    public final boolean isSimulation() {
        return this.turns < DebugUtils.INSTANCE.getSIMULATE_UNTIL_TURN() || this.turns < this.simulateMaxTurns && this.simulateUntilWin;
    }

    public final void nextTurn(@Nullable NextTurnProgress progressBar) {
        Ref.ObjectRef<Civilization> player = new Ref.ObjectRef<Civilization>();
        player.element = this.getCurrentPlayerCiv();
        Ref.IntRef playerIndex = new Ref.IntRef();
        playerIndex.element = this.civilizations.indexOf(player.element);
        if (((Civilization)player.element).isHuman()) {
            new TurnManager((Civilization)player.element).endTurn(progressBar);
            GameInfo.nextTurn$setNextPlayer(playerIndex, this, player);
        }
        boolean isOnline = this.gameParameters.isOnlineMultiplayer();
        while (this.isSimulation() || ((Civilization)player.element).isAI() || GameInfo.nextTurn$shouldAutoProcessHotseatPlayer(isOnline, player, this) || GameInfo.nextTurn$shouldAutoProcessOnlinePlayer(isOnline, player, this)) {
            new TurnManager((Civilization)player.element).startTurn(progressBar);
            new TurnManager((Civilization)player.element).automateTurn();
            WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
            if (this.simulateUntilWin && ((Civilization)player.element).getVictoryManager().hasWon()) {
                this.simulateUntilWin = false;
                Object object = worldScreen;
                if (object != null && (object = ((WorldScreen)object).getAutoPlay()) != null) {
                    ((AutoPlay)object).stopAutoPlay();
                }
                break;
            }
            if (worldScreen != null && worldScreen.getAutoPlay().isAutoPlaying() && ((Civilization)player.element).getVictoryManager().hasWon() && !this.oneMoreTurnMode) {
                worldScreen.getAutoPlay().stopAutoPlay();
            }
            new TurnManager((Civilization)player.element).endTurn(progressBar);
            GameInfo.nextTurn$setNextPlayer(playerIndex, this, player);
        }
        if (this.turns == DebugUtils.INSTANCE.getSIMULATE_UNTIL_TURN()) {
            DebugUtils.INSTANCE.setSIMULATE_UNTIL_TURN(0);
        }
        this.currentTurnStartTime = System.currentTimeMillis();
        this.currentPlayer = ((Civilization)player.element).getCivID();
        this.setCurrentPlayerCiv((Civilization)player.element);
        new TurnManager((Civilization)player.element).startTurn(progressBar);
        if (this.getCurrentPlayerCiv().isSpectator()) {
            this.getCurrentPlayerCiv().getPopupAlerts().clear();
        }
        if (this.turns % 10 == 0 && Gdx.app != null) {
            UncivGame.Companion.getCurrent().getMusicController().chooseTrack(this.getCurrentPlayerCiv().getCivName(), MusicMood.INSTANCE.peaceOrWar(this.getCurrentPlayerCiv().isAtWar()), MusicTrackChooserFlags.Companion.getSetNextTurn());
        }
        this.notifyOfCloseEnemyUnits((Civilization)player.element);
    }

    public static /* synthetic */ void nextTurn$default(GameInfo gameInfo, NextTurnProgress nextTurnProgress, int n, Object object) {
        if ((n & 1) != 0) {
            nextTurnProgress = null;
        }
        gameInfo.nextTurn(nextTurnProgress);
    }

    /*
     * Unable to fully structure code
     */
    private final void notifyOfCloseEnemyUnits(Civilization thisPlayer) {
        $this$map$iv = thisPlayer.getViewableInvisibleUnitsTiles();
        $i$f$map = false;
        var5_5 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var10_14 = (Tile)item$iv$iv;
            var19_12 = destination$iv$iv;
            $i$a$-map-GameInfo$notifyOfCloseEnemyUnits$viewableInvisibleTiles$1 = false;
            var19_12.add(it.getPosition());
        }
        viewableInvisibleTiles = (List)destination$iv$iv;
        $i$f$map = thisPlayer.getViewableTiles();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block14: {
                it = (Tile)element$iv$iv;
                $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$enemyUnitsCloseToTerritory$1 = false;
                if (it.getMilitaryUnit() == null) ** GOTO lbl-1000
                v0 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v0);
                if (Intrinsics.areEqual(v0.getCiv(), thisPlayer)) ** GOTO lbl-1000
                v1 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v1);
                if (!thisPlayer.isAtWarWith(v1.getCiv())) ** GOTO lbl-1000
                if (Intrinsics.areEqual(it.getOwner(), thisPlayer)) ** GOTO lbl-1000
                $this$any$iv = it.getNeighbors();
                $i$f$any = false;
                var15_24 = $this$any$iv.iterator();
                while (var15_24.hasNext()) {
                    neighbor = element$iv = var15_24.next();
                    $i$a$-any-GameInfo$notifyOfCloseEnemyUnits$enemyUnitsCloseToTerritory$1$1 = false;
                    if (!Intrinsics.areEqual(neighbor.getOwner(), thisPlayer)) continue;
                    v2 = true;
                    break block14;
                }
                v2 = false;
            }
            if (v2) {
                v3 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v3);
                ** if (v3.isInvisible((Civilization)thisPlayer) && !viewableInvisibleTiles.contains((Object)it.getPosition())) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v4 = true;
                ** GOTO lbl50
            }
lbl-1000:
            // 5 sources

            {
                v4 = false;
            }
lbl50:
            // 2 sources

            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        enemyUnitsCloseToTerritory = (List)destination$iv$iv;
        $this$filter$iv = enemyUnitsCloseToTerritory;
        var20_28 = thisPlayer;
        var19_12 = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$1 = false;
            if (!Intrinsics.areEqual(it.getOwner(), thisPlayer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var21_29 = (List)destination$iv$iv;
        super.addEnemyUnitNotification(var20_28, var21_29, "in");
        $this$filter$iv = enemyUnitsCloseToTerritory;
        var20_28 = thisPlayer;
        var19_12 = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$2 = false;
            if (!(Intrinsics.areEqual(it.getOwner(), thisPlayer) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var21_29 = (List)destination$iv$iv;
        super.addEnemyUnitNotification(var20_28, var21_29, "near");
        $this$filter$iv = thisPlayer.getCities();
        var20_28 = thisPlayer;
        var19_12 = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block15: {
                city = (City)element$iv$iv;
                $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$3 = false;
                if (!city.canBombard()) ** GOTO lbl-1000
                $this$any$iv = enemyUnitsCloseToTerritory;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v5 = false;
                } else {
                    var15_24 = $this$any$iv.iterator();
                    while (var15_24.hasNext()) {
                        tile = element$iv = var15_24.next();
                        $i$a$-any-GameInfo$notifyOfCloseEnemyUnits$3$1 = false;
                        if (!(tile.aerialDistanceTo(city.getCenterTile()) <= city.getBombardRange())) continue;
                        v5 = true;
                        break block15;
                    }
                    v5 = false;
                }
            }
            if (v5) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            if (!v6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var21_29 = (List)destination$iv$iv;
        super.addBombardNotification(var20_28, var21_29);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Map<String, Victory> getEnabledVictories() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.getRuleset().getVictories();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!((Victory)it.getValue()).getHiddenInVictoryScreen() && this.gameParameters.getVictoryTypes().contains(it.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final void processDiplomaticVictory() {
        if (this.diplomaticVictoryVotesProcessed) {
            return;
        }
        Iterator<Civilization> iterator2 = this.civilizations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civInfo;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!civInfo.getVictoryManager().hasEnoughVotesForDiplomaticVictory()) continue;
            civInfo.getVictoryManager().setHasEverWonDiplomaticVote(true);
        }
        this.diplomaticVictoryVotesProcessed = true;
    }

    public final boolean checkForVictory() {
        if (this.victoryData != null) {
            return true;
        }
        Iterator<Civilization> iterator2 = this.civilizations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            new TurnManager(civ).updateWinningCiv();
            if (this.victoryData == null) continue;
            return true;
        }
        return false;
    }

    private final void addEnemyUnitNotification(Civilization thisPlayer, List<Tile> tiles, String inOrNear) {
        if (tiles.size() < 3) {
            for (Tile tile : tiles) {
                MapUnit mapUnit = tile.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit);
                String unitName = mapUnit.getName();
                String[] stringArray = new String[]{"OtherIcons/Pillage", unitName};
                thisPlayer.addNotification("An enemy [" + unitName + "] was spotted " + inOrNear + " our territory", tile.getPosition(), Notification.NotificationCategory.War, stringArray);
            }
        } else {
            Sequence<HexCoord> positions = SequencesKt.map(CollectionsKt.asSequence((Iterable)tiles), GameInfo::addEnemyUnitNotification$lambda$0);
            String[] stringArray = new String[]{"OtherIcons/Pillage"};
            thisPlayer.addNotification("" + '[' + tiles.size() + "] enemy units were spotted " + inOrNear + " our territory", LocationAction.Companion.invoke(SequencesKt.map(positions, GameInfo::addEnemyUnitNotification$lambda$1)), Notification.NotificationCategory.War, stringArray);
        }
    }

    private final void addBombardNotification(Civilization thisPlayer, List<City> cities) {
        if (cities.size() < 3) {
            for (City city : cities) {
                String[] stringArray = new String[]{"ImprovementIcons/City center", "OtherIcons/CrosshairB"};
                thisPlayer.addNotification("Your city [" + city.getName() + "] can bombard the enemy!", new MapUnitAction(city.getLocation(), 0, 2, null), Notification.NotificationCategory.War, stringArray);
            }
        } else {
            Sequence<MapUnitAction> notificationActions = SequencesKt.map(CollectionsKt.asSequence((Iterable)cities), GameInfo::addBombardNotification$lambda$0);
            String[] stringArray = new String[]{"ImprovementIcons/City center", "OtherIcons/CrosshairB"};
            thisPlayer.addNotification("" + '[' + cities.size() + "] of your cities can bombard the enemy!", notificationActions, Notification.NotificationCategory.War, stringArray);
        }
    }

    public final boolean notifyExploredResources(@NotNull Civilization civInfo, @NotNull String resourceName, int maxDistance, @NotNull Function1<? super Tile, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Notification notification = this.getExploredResourcesNotification(civInfo, resourceName, maxDistance, filter2);
        if (notification == null) {
            return false;
        }
        Notification notification2 = notification;
        civInfo.getNotifications().add(notification2);
        return true;
    }

    public static /* synthetic */ boolean notifyExploredResources$default(GameInfo gameInfo, Civilization civilization, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            function1 = GameInfo::notifyExploredResources$lambda$0;
        }
        return gameInfo.notifyExploredResources(civilization, string, n, function1);
    }

    @Nullable
    public final Notification getExploredResourcesNotification(@NotNull Civilization civ, @NotNull String resourceName, int maxDistance, @NotNull Function1<? super Tile, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        TileResource tileResource = this.getRuleset().getTileResources().get(resourceName);
        if (tileResource == null) {
            return null;
        }
        TileResource resource = tileResource;
        if (!civ.getTech().isRevealed(resource)) {
            return null;
        }
        Sequence relevantCities = SequencesKt.plus(CollectionsKt.asSequence((Iterable)civ.getCities()), SequencesKt.flatMapIterable(SequencesKt.filter(civ.getKnownCivs(), arg_0 -> GameInfo.getExploredResourcesNotification$lambda$1(civ, arg_0)), GameInfo::getExploredResourcesNotification$lambda$2));
        TileResource tileResource2 = this.getRuleset().getTileResources().get(resourceName);
        Intrinsics.checkNotNull(tileResource2);
        Sequence<Tile> exploredRevealTiles = IHasUniques.hasUnique$default(tileResource2, UniqueType.CityStateOnlyResource, null, 2, null) ? SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getAliveCityStates()), arg_0 -> GameInfo.getExploredResourcesNotification$lambda$3(resourceName, arg_0)), GameInfo::getExploredResourcesNotification$lambda$4) : SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.tileMap.getValues()), arg_0 -> GameInfo.getExploredResourcesNotification$lambda$5(resourceName, arg_0));
        Comparator comparator = new Comparator(civ){
            final /* synthetic */ Civilization $civ$inlined;
            {
                this.$civ$inlined = civilization;
            }

            public final int compare(T a, T b) {
                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J,\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"com/unciv/logic/GameInfo$getExploredResourcesNotification$CityTileAndDistance", "", "city", "Lcom/unciv/logic/city/City;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "distance", "", "<init>", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/tile/Tile;I)V", "getCity", "()Lcom/unciv/logic/city/City;", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getDistance", "()I", "component1", "component2", "component3", "copy", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/tile/Tile;I)Lcom/unciv/logic/GameInfo$getExploredResourcesNotification$CityTileAndDistance;", "equals", "", "other", "hashCode", "toString", "", "core"})
                public final class CityTileAndDistance {
                    private final City city;
                    private final Tile tile;
                    private final int distance;

                    public CityTileAndDistance(City city, Tile tile, int distance) {
                        Intrinsics.checkNotNullParameter(city, "city");
                        Intrinsics.checkNotNullParameter(tile, "tile");
                        this.city = city;
                        this.tile = tile;
                        this.distance = distance;
                    }

                    public final City getCity() {
                        return this.city;
                    }

                    public final Tile getTile() {
                        return this.tile;
                    }

                    public final int getDistance() {
                        return this.distance;
                    }

                    public final City component1() {
                        return this.city;
                    }

                    public final Tile component2() {
                        return this.tile;
                    }

                    public final int component3() {
                        return this.distance;
                    }

                    public final CityTileAndDistance copy(City city, Tile tile, int distance) {
                        Intrinsics.checkNotNullParameter(city, "city");
                        Intrinsics.checkNotNullParameter(tile, "tile");
                        return new CityTileAndDistance(city, tile, distance);
                    }

                    public static /* synthetic */ CityTileAndDistance copy$default(CityTileAndDistance cityTileAndDistance, City city, Tile tile, int n, int n2, Object object) {
                        if ((n2 & 1) != 0) {
                            city = cityTileAndDistance.city;
                        }
                        if ((n2 & 2) != 0) {
                            tile = cityTileAndDistance.tile;
                        }
                        if ((n2 & 4) != 0) {
                            n = cityTileAndDistance.distance;
                        }
                        return cityTileAndDistance.copy(city, tile, n);
                    }

                    public String toString() {
                        return "CityTileAndDistance(city=" + this.city + ", tile=" + this.tile + ", distance=" + this.distance + ')';
                    }

                    public int hashCode() {
                        int result2 = this.city.hashCode();
                        result2 = result2 * 31 + this.tile.hashCode();
                        result2 = result2 * 31 + Integer.hashCode(this.distance);
                        return result2;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof CityTileAndDistance)) {
                            return false;
                        }
                        CityTileAndDistance cityTileAndDistance = (CityTileAndDistance)other;
                        if (!Intrinsics.areEqual(this.city, cityTileAndDistance.city)) {
                            return false;
                        }
                        if (!Intrinsics.areEqual(this.tile, cityTileAndDistance.tile)) {
                            return false;
                        }
                        return this.distance == cityTileAndDistance.distance;
                    }
                }
                CityTileAndDistance it = (CityTileAndDistance)a;
                boolean bl = false;
                boolean bl2 = !Intrinsics.areEqual(it.getCity().getCiv(), this.$civ$inlined);
                it = (CityTileAndDistance)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it.getCity().getCiv(), this.$civ$inlined));
            }
        };
        Sequence<CityTileAndDistance> exploredRevealInfo = SequencesKt.distinctBy(SequencesKt.sortedWith(SequencesKt.filter(SequencesKt.flatMap(SequencesKt.filter(exploredRevealTiles, arg_0 -> GameInfo.getExploredResourcesNotification$lambda$6(civ, arg_0)), arg_0 -> GameInfo.getExploredResourcesNotification$lambda$7(relevantCities, arg_0)), arg_0 -> GameInfo.getExploredResourcesNotification$lambda$8(maxDistance, filter2, arg_0)), new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    CityTileAndDistance it = (CityTileAndDistance)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getDistance());
                    it = (CityTileAndDistance)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getDistance());
                }
                return n;
            }
        }), GameInfo::getExploredResourcesNotification$lambda$11);
        Object object = SequencesKt.firstOrNull(exploredRevealInfo);
        if (object == null || (object = ((CityTileAndDistance)object).getCity()) == null) {
            return null;
        }
        Object chosenCity = object;
        Sequence<HexCoord> positions = SequencesKt.map(SequencesKt.sortedWith(exploredRevealInfo, new Comparator((City)chosenCity){
            final /* synthetic */ City $chosenCity$inlined;
            {
                this.$chosenCity$inlined = city;
            }

            public final int compare(T a, T b) {
                CityTileAndDistance it = (CityTileAndDistance)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTile().aerialDistanceTo(this.$chosenCity$inlined.getCenterTile()));
                it = (CityTileAndDistance)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTile().aerialDistanceTo(this.$chosenCity$inlined.getCenterTile()));
            }
        }), GameInfo::getExploredResourcesNotification$lambda$13);
        int positionsCount = SequencesKt.count(positions);
        String text2 = positionsCount == 1 ? '[' + resourceName + "] revealed near [" + ((City)chosenCity).getName() + ']' : "" + '[' + positionsCount + "] sources of [" + resourceName + "] revealed, e.g. near [" + ((City)chosenCity).getName() + ']';
        String[] stringArray = new String[]{"ResourceIcons/" + resourceName};
        return new Notification(text2, stringArray, SequencesKt.asIterable(LocationAction.Companion.invoke(SequencesKt.map(positions, GameInfo::getExploredResourcesNotification$lambda$14))), Notification.NotificationCategory.General);
    }

    public static /* synthetic */ Notification getExploredResourcesNotification$default(GameInfo gameInfo, Civilization civilization, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            function1 = GameInfo::getExploredResourcesNotification$lambda$0;
        }
        return gameInfo.getExploredResourcesNotification(civilization, string, n, function1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransients() {
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object $this$first$iv;
        Map map2;
        boolean bl;
        Iterator $this$groupByTo$iv$iv;
        Object element$iv$iv22;
        void $this$filterNotTo$iv$iv;
        Object newName;
        String it;
        boolean bl2;
        HashSet<String> hashSet;
        void $this$mapTo$iv$iv;
        this.tileMap.setGameInfo(this);
        this.convertOldSavesToNewSaves();
        Object $this$map$iv22 = this.gameParameters.getMods();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv22, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            hashSet = destination$iv$iv;
            bl2 = false;
            hashSet.add((String)((Object)TuplesKt.to(it, Github.INSTANCE.repoNameToFolderName(it, true))));
        }
        for (Object $this$map$iv22 : (List)destination$iv$iv) {
            String oldName = (String)((Pair)$this$map$iv22).component1();
            newName = (String)((Pair)$this$map$iv22).component2();
            if (Intrinsics.areEqual(newName, oldName)) continue;
            this.gameParameters.getMods().remove(oldName);
            this.gameParameters.getMods().add((String)newName);
        }
        if (!((Map)RulesetCache.INSTANCE).containsKey(this.gameParameters.getBaseRuleset()) && ((Map)RulesetCache.INSTANCE).containsKey(StringsKt.replace$default(this.gameParameters.getBaseRuleset(), "-", " ", false, 4, null))) {
            this.gameParameters.setBaseRuleset(StringsKt.replace$default(this.gameParameters.getBaseRuleset(), "-", " ", false, 4, null));
        }
        Iterator iterator2 = this.gameParameters.getMods().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            String mod = (String)e;
            if (((Map)RulesetCache.INSTANCE).containsKey(mod) || !((Map)RulesetCache.INSTANCE).containsKey(StringsKt.replace$default(mod, "-", " ", false, 4, null))) continue;
            this.gameParameters.getMods().remove(mod);
            this.gameParameters.getMods().add(StringsKt.replace$default(mod, "-", " ", false, 4, null));
        }
        this.setRuleset(RulesetCache.INSTANCE.getComplexRuleset(this.gameParameters));
        Iterator<Object> $this$filterNot$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(this.gameParameters.getBaseRuleset()), (Iterable)this.gameParameters.getMods());
        boolean $i$f$filterNot22 = false;
        newName = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv22 : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv22;
            bl2 = false;
            if (this.getRuleset().getMods().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv22);
        }
        List missingMods = (List)destination$iv$iv;
        if (!((Collection)missingMods).isEmpty()) {
            throw new MissingModsException(missingMods);
        }
        BackwardCompatibility.INSTANCE.removeMissingModReferences(this);
        VictoryData victoryData = this.victoryData;
        if (victoryData != null) {
            VictoryData $i$f$filterNot22 = victoryData;
            VictoryData it2 = $i$f$filterNot22;
            boolean bl3 = false;
            it2.setWinningCivObject(this.getCivilization(it2.getWinningCiv()));
        }
        for (Object e : this.getRuleset().getUnits().values()) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            BaseUnit baseUnit = (BaseUnit)e;
            baseUnit.setRuleset(this.getRuleset());
        }
        $this$filterNot$iv = this.getRuleset().getBuildings().values().iterator();
        while ($this$filterNot$iv.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue($this$filterNot$iv.next(), "next(...)");
            building.setRuleset(this.getRuleset());
        }
        Iterator<Civilization> iterator4 = this.civilizations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        $this$filterNot$iv = iterator4;
        while ($this$filterNot$iv.hasNext()) {
            Object object = $this$filterNot$iv.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Civilization civInfo = (Civilization)object;
            civInfo.setGameInfo(this);
        }
        Iterator<Civilization> iterator5 = this.civilizations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
        $this$filterNot$iv = iterator5;
        while ($this$filterNot$iv.hasNext()) {
            Object object = $this$filterNot$iv.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Civilization civInfo = (Civilization)object;
            civInfo.setNationTransient();
            civInfo.getCache().updateState();
        }
        Iterator<Civilization> iterator6 = this.civilizations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator6, "iterator(...)");
        $this$filterNot$iv = iterator6;
        while ($this$filterNot$iv.hasNext()) {
            Object object = $this$filterNot$iv.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Civilization civInfo = (Civilization)object;
            for (Object e : civInfo.getDiplomacy().values()) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                DiplomacyManager diplomacyManager = (DiplomacyManager)e;
                diplomacyManager.setCivInfo(civInfo);
                diplomacyManager.updateHasOpenBorders();
            }
        }
        this.setGlobalTransients();
        TileMap.setTransients$default(this.tileMap, this.getRuleset(), false, 2, null);
        Iterable $this$groupBy$iv = this.tileMap.getTileList();
        boolean $i$f$groupBy232 = false;
        Iterable diplomacyManager = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        element$iv$iv22 = $this$groupByTo$iv$iv.iterator();
        while (element$iv$iv22.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv22.next();
            Tile it3 = (Tile)element$iv$iv3;
            bl = false;
            Integer key$iv$iv = it3.getRow();
            Map map3 = destination$iv$iv2;
            Integer key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv3);
        }
        Iterable $i$f$groupBy232 = destination$iv$iv2.entrySet();
        $this$groupByTo$iv$iv = $i$f$groupBy232.iterator();
        if (!$this$groupByTo$iv$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        destination$iv$iv2 = $this$groupByTo$iv$iv.next();
        if (!$this$groupByTo$iv$iv.hasNext()) {
            map2 = destination$iv$iv2;
        } else {
            Map.Entry it232 = (Map.Entry)((Object)destination$iv$iv2);
            boolean bl32 = false;
            int it232 = ((Number)it232.getKey()).intValue();
            do {
                Object bl32 = $this$groupByTo$iv$iv.next();
                Map.Entry it332 = (Map.Entry)bl32;
                boolean $i$a$-minByOrThrow-GameInfo$setTransients$tilesWithLowestRow$3 = false;
                int it332 = ((Number)it332.getKey()).intValue();
                if (it232 <= it332) continue;
                destination$iv$iv2 = bl32;
                it232 = it332;
            } while ($this$groupByTo$iv$iv.hasNext());
            map2 = destination$iv$iv2;
        }
        List tilesWithLowestRow = (List)((Map.Entry)((Object)map2)).getValue();
        if (tilesWithLowestRow.size() > 2) {
            this.tileMap.getMapParameters().setShape("Rectangular");
        }
        if (Intrinsics.areEqual(this.currentPlayer, "")) {
            Civilization civilization;
            HashSet<String> hashSet2;
            boolean bl4;
            Object element$iv;
            boolean $i$f$first;
            GameInfo gameInfo = this;
            if (this.gameParameters.isOnlineMultiplayer()) {
                block32: {
                    $this$groupBy$iv = this.civilizations;
                    hashSet = gameInfo;
                    $i$f$first = false;
                    $this$groupByTo$iv$iv = $this$first$iv.iterator();
                    while ($this$groupByTo$iv$iv.hasNext()) {
                        element$iv = $this$groupByTo$iv$iv.next();
                        Civilization it4 = (Civilization)element$iv;
                        bl4 = false;
                        if (!(it4.isHuman() && !it4.isSpectator())) continue;
                        break block32;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                hashSet2 = hashSet;
                civilization = (Civilization)element$iv;
            } else {
                block33: {
                    $this$first$iv = this.civilizations;
                    hashSet = gameInfo;
                    $i$f$first = false;
                    $this$groupByTo$iv$iv = $this$first$iv.iterator();
                    while ($this$groupByTo$iv$iv.hasNext()) {
                        element$iv = $this$groupByTo$iv$iv.next();
                        Civilization it2 = (Civilization)element$iv;
                        bl4 = false;
                        if (!it2.isHuman()) continue;
                        break block33;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                hashSet2 = hashSet;
                civilization = (Civilization)element$iv;
            }
            ((GameInfo)((Object)hashSet2)).setCurrentPlayerCiv(civilization);
            this.currentPlayer = this.getCurrentPlayerCiv().getCivID();
        } else {
            this.setCurrentPlayerCiv(this.getCivilization(this.currentPlayer));
        }
        for (Object e : this.religions.values()) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Religion religion = (Religion)e;
            religion.setTransients(this);
        }
        Iterator<Civilization> iterator7 = this.civilizations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator7, "iterator(...)");
        $this$first$iv = iterator7;
        while ($this$first$iv.hasNext()) {
            Civilization civInfo;
            Intrinsics.checkNotNullExpressionValue($this$first$iv.next(), "next(...)");
            civInfo.setTransients();
        }
        this.tileMap.setNeutralTransients();
        BackwardCompatibility.INSTANCE.convertFortify(this);
        this.updateCivilizationState();
        this.spaceResources.clear();
        Collection<Building> collection = this.getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        $this$first$iv = collection;
        hashSet = this.spaceResources;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
            Building it5 = (Building)element$iv$iv4;
            bl = false;
            Intrinsics.checkNotNull(it5);
            if (!IHasUniques.hasUnique$default(it5, UniqueType.SpaceshipPart, null, 2, null)) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv5 : $this$flatMapTo$iv$iv) {
            Building it6 = (Building)element$iv$iv5;
            bl = false;
            Intrinsics.checkNotNull(it6);
            Set set = IConstruction.getResourceRequirementsPerTurn$default(it6, null, 1, null).keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            Iterable list$iv$iv = set;
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv3);
        Collection<Victory> collection2 = this.getRuleset().getVictories().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        $this$flatMap$iv = collection2;
        hashSet = this.spaceResources;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv6 : $this$flatMapTo$iv$iv) {
            Victory it7 = (Victory)element$iv$iv6;
            bl = false;
            Iterable list$iv$iv = it7.getRequiredSpaceshipParts();
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv3);
        this.barbarians.setTransients(this);
        BackwardCompatibility.INSTANCE.guaranteeUnitPromotions(this);
        BackwardCompatibility.INSTANCE.migrateToTileHistory(this);
        BackwardCompatibility.INSTANCE.migrateGreatGeneralPools(this);
        BackwardCompatibility.INSTANCE.ensureUnitIds(this);
    }

    public final void setGlobalTransients() {
        Difficulty difficulty = this.getRuleset().getDifficulties().get(this.difficulty);
        Intrinsics.checkNotNull(difficulty);
        this.difficultyObject = difficulty;
        Speed speed = this.getRuleset().getSpeeds().get(this.gameParameters.getSpeed());
        Intrinsics.checkNotNull(speed);
        this.setSpeed(speed);
        GlobalUniques globalUniques = this.getRuleset().getGlobalUniques$core();
        IHasUniques[] iHasUniquesArray = new IHasUniques[2];
        iHasUniquesArray[0] = this.getSpeed();
        Difficulty difficulty2 = this.difficultyObject;
        if (difficulty2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("difficultyObject");
            difficulty2 = null;
        }
        iHasUniquesArray[1] = difficulty2;
        this.combinedGlobalUniques = GlobalUniques.Companion.combine(globalUniques, iHasUniquesArray);
    }

    private final void updateCivilizationState() {
        Sequence $this$sortedByDescending$iv = CollectionsKt.asSequence((Iterable)this.civilizations);
        boolean $i$f$sortedByDescending2 = false;
        Iterator iterator2 = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isCityState());
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.isCityState());
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization civInfo = (Civilization)iterator2.next();
            Iterator<MapUnit> $i$f$sortedByDescending2 = civInfo.getUnits().getCivUnits().iterator();
            while ($i$f$sortedByDescending2.hasNext()) {
                MapUnit unit = $i$f$sortedByDescending2.next();
                MapUnit.updateVisibleTiles$default(unit, false, null, 2, null);
            }
            if (civInfo.getPlayerType() == PlayerType.Human) {
                civInfo.getExploredRegion().setMapParameters(this.tileMap.getMapParameters());
            }
            civInfo.getCache().updateOurTiles();
            civInfo.getCache().updateSightAndResources();
            civInfo.getCache().updateCitiesConnectedToCapital(true);
            LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
            for (City city : civInfo.getCities()) {
                city.getCityStats().updateTileStats(localUniqueCache);
                city.getCityStats().updateCityHappiness(city.getCityConstructions().getStats(localUniqueCache));
            }
            for (City city : civInfo.getCities()) {
                if (city.getCityConstructions().getConstructionQueue().isEmpty()) {
                    city.getCityConstructions().chooseNextConstruction();
                }
                if (!this.getRuleset().getTileResources().containsKey(city.getDemandedResource())) {
                    city.setDemandedResource("");
                }
                CityStats.update$default(city.getCityStats(), null, false, false, localUniqueCache, false, 23, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void convertOldSavesToNewSaves() {
        Object v2;
        Iterable $this$firstOrNull$iv;
        block3: {
            $this$firstOrNull$iv = this.gameParameters.getMods();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Object object = (Ruleset)RulesetCache.INSTANCE.get((Object)it);
                boolean bl2 = object != null && (object = ((Ruleset)object).getModOptions()) != null ? ((ModOptions)object).isBaseRuleset() : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        String baseRulesetInMods = v2;
        if (baseRulesetInMods != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            this.gameParameters.setBaseRuleset(baseRulesetInMods);
            $this$firstOrNull$iv = this.gameParameters.getMods();
            GameParameters gameParameters = this.gameParameters;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it, baseRulesetInMods))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            gameParameters.setMods(new LinkedHashSet<String>(collection));
        }
    }

    @Readonly
    @NotNull
    public final GameInfoPreview asPreview() {
        return new GameInfoPreview(this);
    }

    private static final Civilization clone$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.clone();
    }

    private static final Pair clone$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it.getKey(), ((Religion)it.getValue()).clone());
    }

    /*
     * WARNING - void declaration
     */
    private static final Map civMap_delegate$lambda$0(GameInfo this$0) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this$0.civilizations;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Civilization civilization = (Civilization)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getCivID(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final Iterable getCities$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCities();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getCivsSorted$lambda$0(boolean $includeDefeated, boolean $includeCityStates, Function1 $additionalFilter, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.isBarbarian()) return true;
        if (it.isSpectator()) return true;
        if (!$includeDefeated) {
            if (it.isDefeated()) return true;
        }
        if (!$includeCityStates) {
            if (it.isCityState()) return true;
        }
        Function1 function1 = $additionalFilter;
        if (function1 == null) return false;
        if ((Boolean)function1.invoke(it) != false) return false;
        return true;
    }

    private static final void nextTurn$setNextPlayer(Ref.IntRef playerIndex, GameInfo this$0, Ref.ObjectRef<Civilization> player) {
        playerIndex.element = (playerIndex.element + 1) % this$0.civilizations.size();
        if (playerIndex.element == 0) {
            int n = this$0.turns;
            this$0.turns = n + 1;
            if (DebugUtils.INSTANCE.getSIMULATE_UNTIL_TURN() != 0) {
                Object[] objectArray = new Object[]{this$0.turns};
                LogKt.debug("Starting simulation of turn %s", objectArray);
            }
        }
        Civilization civilization = this$0.civilizations.get(playerIndex.element);
        Intrinsics.checkNotNullExpressionValue(civilization, "get(...)");
        player.element = civilization;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private static final boolean nextTurn$shouldAutoProcessHotseatPlayer(boolean isOnline, Ref.ObjectRef<Civilization> player, GameInfo this$0) {
        Civilization it;
        Object element$iv2;
        boolean bl;
        if (isOnline) return false;
        if (!((Civilization)player.element).isDefeated()) return false;
        Iterable $this$any$iv = this$0.civilizations;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv2 : $this$any$iv) {
                it = (Civilization)element$iv2;
                boolean bl2 = false;
                if (it.isHuman() && it.isAlive()) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        Iterable $this$first$iv = this$0.civilizations;
        boolean $i$f$first = false;
        Iterator iterator2 = $this$first$iv.iterator();
        do {
            if (!iterator2.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
            element$iv2 = iterator2.next();
            it = (Civilization)element$iv2;
            boolean bl4 = false;
        } while (!it.isHuman());
        if (Intrinsics.areEqual(element$iv2, player.element)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private static final boolean nextTurn$shouldAutoProcessOnlinePlayer(boolean isOnline, Ref.ObjectRef<Civilization> player, GameInfo this$0) {
        Civilization it;
        Object element$iv2;
        boolean bl;
        if (!isOnline) return false;
        if (((Civilization)player.element).isSpectator()) return true;
        if (!((Civilization)player.element).isDefeated()) return false;
        Iterable $this$any$iv = this$0.civilizations;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv2 : $this$any$iv) {
                it = (Civilization)element$iv2;
                boolean bl2 = false;
                if (it.isHuman() && it.isAlive()) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        Iterable $this$first$iv = this$0.civilizations;
        boolean $i$f$first = false;
        Iterator iterator2 = $this$first$iv.iterator();
        do {
            if (!iterator2.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
            element$iv2 = iterator2.next();
            it = (Civilization)element$iv2;
            boolean bl4 = false;
        } while (!it.isHuman());
        if (Intrinsics.areEqual(element$iv2, player.element)) return false;
        return true;
    }

    private static final HexCoord addEnemyUnitNotification$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition();
    }

    private static final HexCoord addEnemyUnitNotification$lambda$1(HexCoord it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it;
    }

    private static final MapUnitAction addBombardNotification$lambda$0(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new MapUnitAction(it.getLocation(), 0, 2, null);
    }

    private static final boolean notifyExploredResources$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean getExploredResourcesNotification$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean getExploredResourcesNotification$lambda$1(Civilization $civ, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isCityState() && Intrinsics.areEqual(it.getAllyCiv(), $civ);
    }

    private static final Iterable getExploredResourcesNotification$lambda$2(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCities();
    }

    private static final boolean getExploredResourcesNotification$lambda$3(String $resourceName, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getCityStateResource(), $resourceName);
    }

    private static final Tile getExploredResourcesNotification$lambda$4(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        City city = Civilization.getCapital$default(it, false, 1, null);
        Intrinsics.checkNotNull(city);
        return city.getCenterTile();
    }

    private static final boolean getExploredResourcesNotification$lambda$5(String $resourceName, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getResource(), $resourceName);
    }

    private static final boolean getExploredResourcesNotification$lambda$6(Civilization $civ, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $civ.hasExplored(it);
    }

    private static final Sequence getExploredResourcesNotification$lambda$7(Sequence $relevantCities, Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.map($relevantCities, arg_0 -> GameInfo.getExploredResourcesNotification$lambda$7$0(tile, arg_0));
    }

    private static final getExploredResourcesNotification.CityTileAndDistance getExploredResourcesNotification$lambda$7$0(Tile $tile, City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        return new CityTileAndDistance(city, $tile, $tile.aerialDistanceTo(city.getCenterTile()));
    }

    private static final boolean getExploredResourcesNotification$lambda$8(int $maxDistance, Function1 $filter, getExploredResourcesNotification.CityTileAndDistance it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDistance() <= $maxDistance && (Boolean)$filter.invoke(it.getTile()) != false;
    }

    private static final Tile getExploredResourcesNotification$lambda$11(getExploredResourcesNotification.CityTileAndDistance it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTile();
    }

    private static final HexCoord getExploredResourcesNotification$lambda$13(getExploredResourcesNotification.CityTileAndDistance it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTile().getPosition();
    }

    private static final HexCoord getExploredResourcesNotification$lambda$14(HexCoord it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it;
    }
}

