/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u001e\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0015\u001a\u00020\nH\u0003J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/automation/unit/HeadTowardsEnemyCityAutomation;", "", "<init>", "()V", "tryHeadTowardsEnemyCity", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getEnemyCitiesByPriority", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/city/City;", "maxDistanceFromCityToConsiderForLandingArea", "", "minDistanceFromCityToConsiderForLandingArea", "headTowardsEnemyCity", "closestReachableEnemyCity", "Lcom/unciv/logic/map/tile/Tile;", "shortestPath", "", "cannotTakeCitySoon", "ourUnitsAroundEnemyCity", "city", "headToLandingGrounds", "headTowardsEnemyCityLongRange", "unitDistanceToTiles", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "unitRange", "core"})
@SourceDebugExtension(value={"SMAP\nHeadTowardsEnemyCityAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadTowardsEnemyCityAutomation.kt\ncom/unciv/logic/automation/unit/HeadTowardsEnemyCityAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n183#2,2:165\n1923#2,14:167\n608#2:187\n608#2:189\n183#2,2:190\n1285#3,2:181\n1299#3,4:183\n1#4:188\n*S KotlinDebug\n*F\n+ 1 HeadTowardsEnemyCityAutomation.kt\ncom/unciv/logic/automation/unit/HeadTowardsEnemyCityAutomation\n*L\n21#1:165,2\n39#1:167,14\n46#1:187\n119#1:189\n120#1:190,2\n44#1:181,2\n44#1:183,4\n*E\n"})
public final class HeadTowardsEnemyCityAutomation {
    @NotNull
    public static final HeadTowardsEnemyCityAutomation INSTANCE = new HeadTowardsEnemyCityAutomation();
    private static final int maxDistanceFromCityToConsiderForLandingArea = 5;
    private static final int minDistanceFromCityToConsiderForLandingArea = 3;

    private HeadTowardsEnemyCityAutomation() {
    }

    public final boolean tryHeadTowardsEnemyCity(@NotNull MapUnit unit) {
        City city;
        block3: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (unit.getCiv().getCities().isEmpty()) {
                return false;
            }
            Sequence<City> $this$firstOrNull$iv = this.getEnemyCitiesByPriority(unit);
            boolean $i$f$firstOrNull = false;
            Iterator<City> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                City element$iv;
                City it = element$iv = iterator2.next();
                boolean bl = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                city = element$iv;
                break block3;
            }
            city = null;
        }
        City city2 = city;
        if (city2 == null) {
            return false;
        }
        City closestReachableEnemyCity = city2;
        return this.headTowardsEnemyCity(unit, closestReachableEnemyCity.getCenterTile(), UnitMovement.getShortestPath$default(unit.getMovement(), closestReachableEnemyCity.getCenterTile(), false, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Sequence<City> getEnemyCitiesByPriority(@NotNull MapUnit unit) {
        void $this$sortedBy$iv;
        void $this$associateWithTo$iv$iv;
        Sequence<Map.Entry> $this$associateWith$iv;
        Object minElem$iv;
        Object v0;
        Object $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Sequence<Civilization> enemies = SequencesKt.filter(unit.getCiv().getKnownCivs(), arg_0 -> HeadTowardsEnemyCityAutomation.getEnemyCitiesByPriority$lambda$0(unit, arg_0));
        Sequence<NextTurnAutomation.CityDistance> sequence = SequencesKt.mapNotNull(enemies, arg_0 -> HeadTowardsEnemyCityAutomation.getEnemyCitiesByPriority$lambda$1(unit, arg_0));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                NextTurnAutomation.CityDistance it = (NextTurnAutomation.CityDistance)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getAerialDistance();
                do {
                    Object e$iv = iterator$iv.next();
                    NextTurnAutomation.CityDistance it2 = (NextTurnAutomation.CityDistance)e$iv;
                    $i$a$-minByOrNull-HeadTowardsEnemyCityAutomation$getEnemyCitiesByPriority$closestEnemyCity$2 = false;
                    int v$iv = it2.getAerialDistance();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        NextTurnAutomation.CityDistance cityDistance = v0;
        if (cityDistance == null || ($this$minByOrNull$iv = cityDistance.getCity()) == null) {
            return SequencesKt.emptySequence();
        }
        City closestEnemyCity = $this$minByOrNull$iv;
        $this$minByOrNull$iv = closestEnemyCity.getCiv().getCities();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        minElem$iv = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            City city = (City)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getCenterTile().aerialDistanceTo(closestEnemyCity.getCenterTile());
            map2.put(t, n);
        }
        $this$associateWith$iv = SequencesKt.filterNot(MapsKt.asSequence(destination$iv$iv), HeadTowardsEnemyCityAutomation::getEnemyCitiesByPriority$lambda$4);
        boolean $i$f$sortedBy = false;
        Sequence<City> enemyCitiesByPriority = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        }), HeadTowardsEnemyCityAutomation::getEnemyCitiesByPriority$lambda$6);
        if (unit.getBaseUnit().isRanged()) {
            enemyCitiesByPriority = SequencesKt.filterNot(enemyCitiesByPriority, HeadTowardsEnemyCityAutomation::getEnemyCitiesByPriority$lambda$7);
        }
        return enemyCitiesByPriority;
    }

    public final boolean headTowardsEnemyCity(@NotNull MapUnit unit, @NotNull Tile closestReachableEnemyCity, @NotNull List<Tile> shortestPath) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(closestReachableEnemyCity, "closestReachableEnemyCity");
        Intrinsics.checkNotNullParameter(shortestPath, "shortestPath");
        PathsToTilesWithinTurn unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        int unitRange = unit.getRange();
        if (unitRange > 2) {
            return this.headTowardsEnemyCityLongRange(closestReachableEnemyCity, unitDistanceToTiles, unitRange, unit);
        }
        Tile nextTileInPath = shortestPath.get(0);
        if (unit.getCurrentTile().aerialDistanceTo(closestReachableEnemyCity) > 5 && shortestPath.size() > 3) {
            UnitMovement.moveToTile$default(unit.getMovement(), nextTileInPath, false, 2, null);
            return true;
        }
        Sequence<MapUnit> ourUnitsAroundEnemyCity = SequencesKt.filter(SequencesKt.flatMap(closestReachableEnemyCity.getTilesInDistance(6), HeadTowardsEnemyCityAutomation::headTowardsEnemyCity$lambda$0), arg_0 -> HeadTowardsEnemyCityAutomation.headTowardsEnemyCity$lambda$1(unit, arg_0));
        City city = closestReachableEnemyCity.getCity();
        Intrinsics.checkNotNull(city);
        City city2 = city;
        if (this.cannotTakeCitySoon(ourUnitsAroundEnemyCity, city2)) {
            return this.headToLandingGrounds(closestReachableEnemyCity, unit);
        }
        UnitMovement.moveToTile$default(unit.getMovement(), nextTileInPath, false, 2, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final boolean cannotTakeCitySoon(Sequence<MapUnit> ourUnitsAroundEnemyCity, City city) {
        CityCombatant cityCombatant = new CityCombatant(city);
        Sequence<MapUnit> sequence = ourUnitsAroundEnemyCity;
        int n = 0;
        Iterator<MapUnit> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            MapUnit mapUnit;
            MapUnit mapUnit2 = mapUnit = iterator2.next();
            int n2 = n;
            boolean bl = false;
            int n3 = BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new MapUnitCombatant((MapUnit)it), cityCombatant, null, 0.0f, 12, null);
            n = n2 + n3;
        }
        int expectedDamagePerTurn = n;
        int cityHealingPerTurn = 20;
        return expectedDamagePerTurn < city.getHealth() && (expectedDamagePerTurn <= cityHealingPerTurn || city.getHealth() / (expectedDamagePerTurn - cityHealingPerTurn) > 5);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean headToLandingGrounds(Tile closestReachableEnemyCity, MapUnit unit) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Sequence<Tile> sequence = SequencesKt.filter(closestReachableEnemyCity.getTilesInDistanceRange(new IntRange(3, 5)), arg_0 -> HeadTowardsEnemyCityAutomation.headToLandingGrounds$lambda$0(unit, arg_0));
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!((UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) || Intrinsics.areEqual(it, unit.getCurrentTile())) && unit.getMovement().canReach(it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Tile tileToHeadTo = v0;
        if (tileToHeadTo != null) {
            unit.getMovement().headTowards(tileToHeadTo);
        }
        return true;
    }

    private final boolean headTowardsEnemyCityLongRange(Tile closestReachableEnemyCity, PathsToTilesWithinTurn unitDistanceToTiles, int unitRange, MapUnit unit) {
        if (SequencesKt.contains(closestReachableEnemyCity.getTilesInDistance(unitRange), unit.getTile())) {
            return true;
        }
        Set<Tile> tilesInBombardRange = SequencesKt.toSet(closestReachableEnemyCity.getTilesInDistance(2));
        Sequence<Map.Entry> candidateTiles = SequencesKt.filter(MapsKt.asSequence(unitDistanceToTiles), arg_0 -> HeadTowardsEnemyCityAutomation.headTowardsEnemyCityLongRange$lambda$0(closestReachableEnemyCity, unitRange, tilesInBombardRange, unit, arg_0));
        Function1[] function1Array = new Function1[]{arg_0 -> HeadTowardsEnemyCityAutomation.headTowardsEnemyCityLongRange$lambda$1(closestReachableEnemyCity, arg_0), HeadTowardsEnemyCityAutomation::headTowardsEnemyCityLongRange$lambda$2};
        Map.Entry tileToMoveTo = SequencesKt.firstOrNull(SequencesKt.sortedWith(candidateTiles, ComparisonsKt.compareBy(function1Array)));
        if (tileToMoveTo != null) {
            unit.getMovement().headTowards((Tile)tileToMoveTo.getKey());
            return true;
        }
        return false;
    }

    private static final boolean getEnemyCitiesByPriority$lambda$0(MapUnit $unit, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $unit.getCiv().isAtWarWith(it) && !((Collection)it.getCities()).isEmpty();
    }

    private static final NextTurnAutomation.CityDistance getEnemyCitiesByPriority$lambda$1(MapUnit $unit, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return NextTurnAutomation.INSTANCE.getForeignCityNearCapital(Civilization.getCapital$default($unit.getCiv(), false, 1, null), it);
    }

    private static final boolean getEnemyCitiesByPriority$lambda$4(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Number)it.getValue()).intValue() > 10;
    }

    private static final City getEnemyCitiesByPriority$lambda$6(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (City)it.getKey();
    }

    private static final boolean getEnemyCitiesByPriority$lambda$7(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getHealth() == 1;
    }

    private static final Sequence headTowardsEnemyCity$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnits();
    }

    private static final boolean headTowardsEnemyCity$lambda$1(MapUnit $unit, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMilitary() && Intrinsics.areEqual(it.getCiv(), $unit.getCiv());
    }

    private static final boolean headToLandingGrounds$lambda$0(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && $unit.getDamageFromTerrain(it) <= 0;
    }

    private static final boolean headTowardsEnemyCityLongRange$lambda$0(Tile $closestReachableEnemyCity, int $unitRange, Set $tilesInBombardRange, MapUnit $unit, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Tile)it.getKey()).aerialDistanceTo($closestReachableEnemyCity) >= $unitRange && !$tilesInBombardRange.contains(it.getKey()) && $unit.getDamageFromTerrain((Tile)it.getKey()) <= 0 && UnitMovement.canMoveTo$default($unit.getMovement(), (Tile)it.getKey(), false, false, false, 14, null);
    }

    private static final Comparable headTowardsEnemyCityLongRange$lambda$1(Tile $closestReachableEnemyCity, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.valueOf(((Tile)it.getKey()).aerialDistanceTo($closestReachableEnemyCity));
    }

    private static final Comparable headTowardsEnemyCityLongRange$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Float.valueOf(((UnitMovement.ParentTileAndTotalMovement)it.getValue()).getTotalMovement());
    }
}

