/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.unit.CityLocationTileRanker;
import com.unciv.logic.automation.unit.CivilianUnitAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.battle.GreatGeneralImplementation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsFromUniques;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/automation/unit/SpecificUnitAutomation;", "", "<init>", "()V", "automateGreatGeneral", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "automateCitadelPlacer", "automateSettlerActions", "", "dangerousTiles", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashSet;", "automateImprovementPlacer", "conductTradeMission", "speedupWonderConstruction", "getWonderThatWouldBenefitFromBeingSpedUp", "Lcom/unciv/models/ruleset/Building;", "city", "Lcom/unciv/logic/city/City;", "automateAddInCapital", "core"})
@SourceDebugExtension(value={"SMAP\nSpecificUnitAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificUnitAutomation.kt\ncom/unciv/logic/automation/unit/SpecificUnitAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1276#2,3:348\n608#2:351\n183#2,2:352\n1463#2,14:354\n622#2:375\n183#2,2:376\n1255#2:407\n1255#2,2:408\n1256#2:410\n622#2:411\n183#2,2:412\n608#2:459\n1255#2,2:460\n1255#2,2:462\n1276#2,3:464\n536#3:368\n521#3,6:369\n1999#4,14:378\n1999#4,14:392\n1068#4:406\n774#4:414\n865#4,2:415\n1387#4:417\n1475#4,5:418\n774#4:423\n865#4,2:424\n1056#4:426\n295#4,2:427\n774#4:429\n865#4,2:430\n1617#4,9:432\n1869#4:441\n1870#4:443\n1626#4:444\n2423#4,14:445\n1#5:442\n*S KotlinDebug\n*F\n+ 1 SpecificUnitAutomation.kt\ncom/unciv/logic/automation/unit/SpecificUnitAutomation\n*L\n36#1:348,3\n50#1:351\n59#1:352,2\n96#1:354,14\n133#1:375\n134#1:376,2\n217#1:407\n218#1:408,2\n217#1:410\n229#1:411\n236#1:412,2\n331#1:459\n44#1:460,2\n48#1:462,2\n151#1:464,3\n107#1:368\n107#1:369,6\n153#1:378,14\n186#1:392,14\n188#1:406\n262#1:414\n262#1:415,2\n268#1:417\n268#1:418,5\n269#1:423\n269#1:424,2\n270#1:426\n272#1:427,2\n296#1:429\n296#1:430,2\n303#1:432,9\n303#1:441\n303#1:443\n303#1:444\n306#1:445,14\n303#1:442\n*E\n"})
public final class SpecificUnitAutomation {
    @NotNull
    public static final SpecificUnitAutomation INSTANCE = new SpecificUnitAutomation();

    private SpecificUnitAutomation() {
    }

    public final boolean automateGreatGeneral(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Tile tile = GreatGeneralImplementation.INSTANCE.getBestAffectedTroopsTile(unit);
        if (tile == null) {
            return false;
        }
        Tile maxAffectedTroopsTile = tile;
        unit.getMovement().headTowards(maxAffectedTroopsTile);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean automateCitadelPlacer(@NotNull MapUnit unit) {
        Object v0;
        block6: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (MapUnit.hasUnique$default(unit, UniqueType.StrengthBonusInRadius, null, false, 6, null)) {
                Sequence<MapUnit> $this$count$iv = unit.getCiv().getUnits().getCivUnits();
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    MapUnit element$iv;
                    MapUnit it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!MapUnit.hasUnique$default(it, UniqueType.StrengthBonusInRadius, null, false, 6, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                if (count$iv < 3) {
                    return false;
                }
            }
            Sequence enemyCities = SequencesKt.flatMapIterable(SequencesKt.filter(unit.getCiv().getKnownCivs(), arg_0 -> SpecificUnitAutomation.automateCitadelPlacer$lambda$1(unit, arg_0)), SpecificUnitAutomation::automateCitadelPlacer$lambda$2);
            Sequence<Tile> count$iv = SequencesKt.filter(SequencesKt.flatMap(SequencesKt.filter(SequencesKt.flatMap(enemyCities, SpecificUnitAutomation::automateCitadelPlacer$lambda$3), arg_0 -> SpecificUnitAutomation.automateCitadelPlacer$lambda$4(unit, arg_0)), SpecificUnitAutomation::automateCitadelPlacer$lambda$5), arg_0 -> SpecificUnitAutomation.automateCitadelPlacer$lambda$6(unit, arg_0));
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    int distance = it.aerialDistanceTo(this.$unit$inlined.getCurrentTile());
                    Civilization owner = it.getOwner();
                    int n = owner != null ? distance - MathKt.roundToInt(owner.getWorkerAutomation().getBasePriority(it, this.$unit$inlined)) : distance;
                    it = (Tile)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    distance = it.aerialDistanceTo(this.$unit$inlined.getCurrentTile());
                    owner = it.getOwner();
                    return ComparisonsKt.compareValues(comparable, owner != null ? distance - MathKt.roundToInt(owner.getWorkerAutomation().getBasePriority(it, this.$unit$inlined)) : distance);
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        Tile tileToSteal = v0;
        if (tileToSteal != null) {
            Object object;
            unit.getMovement().headTowards(tileToSteal);
            if (unit.hasMovement() && Intrinsics.areEqual(unit.getCurrentTile(), tileToSteal) && (object = SequencesKt.firstOrNull(UnitActionsFromUniques.INSTANCE.getImprovementConstructionActionsFromGeneralUnique(unit, unit.getCurrentTile()))) != null && (object = ((UnitAction)object).getAction()) != null) {
                object.invoke();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void automateSettlerActions(@NotNull MapUnit unit, @NotNull HashSet<Tile> dangerousTiles) {
        boolean shouldSettleNow;
        boolean shouldSettle;
        UnitAction foundCityAction;
        Sequence<Object> allUnsettledSettlers;
        Object foundCityAction22;
        Tile bestCityLocation;
        CityLocationTileRanker.BestTilesToFoundCity bestTilesInfo;
        block38: {
            block39: {
                Intrinsics.checkNotNullParameter(unit, "unit");
                Intrinsics.checkNotNullParameter(dangerousTiles, "dangerousTiles");
                Integer rangeToSearch = unit.getCiv().getCities().isEmpty() && unit.getCiv().getGameInfo().getTurns() < 4 ? Integer.valueOf(RangesKt.coerceAtLeast(3 - unit.getCiv().getGameInfo().getTurns(), 1)) : null;
                float minimumTileValue = unit.getCiv().getGameInfo().getRuleset().getModOptions().getConstants().getMinimumCityLocationTileValue();
                bestTilesInfo = CityLocationTileRanker.INSTANCE.getBestTilesToFoundCity(unit, rangeToSearch, minimumTileValue);
                bestCityLocation = null;
                if (unit.getCiv().getGameInfo().getTurns() == 0 && unit.getCiv().getCities().isEmpty() && bestTilesInfo.getTileRankMap().containsKey(unit.getTile())) {
                    Iterator e$iv;
                    Iterator iterator2;
                    foundCityAction22 = UnitActionsFromUniques.INSTANCE.getFoundCityAction$core(unit, unit.getTile());
                    allUnsettledSettlers = SequencesKt.filter(unit.getCiv().getUnits().getCivUnits(), arg_0 -> SpecificUnitAutomation.automateSettlerActions$lambda$0(unit, arg_0));
                    Object $this$maxByOrNull$iv = allUnsettledSettlers;
                    boolean $i$f$maxByOrNull = false;
                    Iterator<Object> iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        iterator2 = null;
                    } else {
                        Iterator maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            iterator2 = maxElem$iv;
                        } else {
                            float f;
                            MapUnit it = (MapUnit)((Object)maxElem$iv);
                            boolean bl = false;
                            if (bestTilesInfo.getTileRankMap().containsKey(it.getTile())) {
                                Float f2 = bestTilesInfo.getTileRankMap().get(it.getTile());
                                Intrinsics.checkNotNull(f2);
                                f = ((Number)f2).floatValue();
                            } else {
                                f = -1.0f;
                            }
                            float maxValue$iv = f;
                            do {
                                float v$iv;
                                float f3;
                                e$iv = iterator$iv.next();
                                MapUnit it2 = (MapUnit)((Object)e$iv);
                                $i$a$-maxByOrNull-SpecificUnitAutomation$automateSettlerActions$bestSettlerInRange$1 = false;
                                if (bestTilesInfo.getTileRankMap().containsKey(it2.getTile())) {
                                    Float f4 = bestTilesInfo.getTileRankMap().get(it2.getTile());
                                    Intrinsics.checkNotNull(f4);
                                    f3 = ((Number)f4).floatValue();
                                } else {
                                    f3 = v$iv = -1.0f;
                                }
                                if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            iterator2 = maxElem$iv;
                        }
                    }
                    MapUnit bestSettlerInRange = (MapUnit)((Object)iterator2);
                    if (Intrinsics.areEqual(bestSettlerInRange, unit)) {
                        UnitAction unitAction = foundCityAction22;
                        if ((unitAction != null ? unitAction.getAction() : null) != null) {
                            ((UnitAction)foundCityAction22).getAction().invoke();
                            return;
                        }
                    }
                    if (bestSettlerInRange != null) {
                        void $this$filterTo$iv$iv;
                        Iterator $this$filter$iv;
                        $this$maxByOrNull$iv = bestTilesInfo.getTileRankMap();
                        CityLocationTileRanker.BestTilesToFoundCity bestTilesToFoundCity = bestTilesInfo;
                        boolean $i$f$filter = false;
                        iterator$iv = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap();
                        boolean $i$f$filterTo = false;
                        e$iv = $this$filterTo$iv$iv.entrySet().iterator();
                        while (e$iv.hasNext()) {
                            Map.Entry element$iv$iv;
                            Map.Entry it = element$iv$iv = e$iv.next();
                            boolean bl = false;
                            if (!(((Tile)it.getKey()).aerialDistanceTo(bestSettlerInRange.getTile()) > 4)) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map map2 = destination$iv$iv;
                        bestTilesToFoundCity.setTileRankMap(new HashMap<Tile, Float>(map2));
                    }
                }
                if (!bestTilesInfo.getTileRankMap().containsKey(unit.getTile())) break block38;
                if (bestTilesInfo.getBestTile() == null) break block39;
                Float f = bestTilesInfo.getTileRankMap().get(unit.getTile());
                Intrinsics.checkNotNull(f);
                if (!(((Number)f).floatValue() >= bestTilesInfo.getBestTileRank() - (float)2)) break block38;
            }
            bestCityLocation = unit.getTile();
        }
        if (bestCityLocation == null && bestTilesInfo.getBestTile() != null) {
            UnitMovement unitMovement = unit.getMovement();
            Tile tile = bestTilesInfo.getBestTile();
            Intrinsics.checkNotNull(tile);
            int foundCityAction22 = UnitMovement.getShortestPath$default(unitMovement, tile, false, 2, null).size();
            boolean bl = 1 <= foundCityAction22 ? foundCityAction22 < 4 : false;
            if (bl) {
                bestCityLocation = bestTilesInfo.getBestTile();
            }
        }
        if (bestCityLocation == null) {
            Object v11;
            block37: {
                void $this$firstOrNull$iv;
                Sequence $this$sortedByDescending$iv;
                Set<Map.Entry<Tile, Float>> set = bestTilesInfo.getTileRankMap().entrySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
                allUnsettledSettlers = SequencesKt.filter(CollectionsKt.asSequence((Iterable)set), arg_0 -> SpecificUnitAutomation.automateSettlerActions$lambda$3(bestTilesInfo, arg_0));
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)b;
                        boolean bl = false;
                        Comparable comparable = (Float)it.getValue();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getValue()));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry p0 = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!SpecificUnitAutomation.automateSettlerActions$isTileRankOK(dangerousTiles, unit, p0)) continue;
                    v11 = element$iv;
                    break block37;
                }
                v11 = null;
            }
            foundCityAction22 = v11;
            Tile tile = bestCityLocation = foundCityAction22 != null ? (Tile)foundCityAction22.getKey() : null;
        }
        if (bestCityLocation == null && bestTilesInfo.getBestTile() != null) {
            UnitMovement unitMovement = unit.getMovement();
            Tile tile = bestTilesInfo.getBestTile();
            Intrinsics.checkNotNull(tile);
            int foundCityAction22 = UnitMovement.getShortestPath$default(unitMovement, tile, false, 2, null).size();
            boolean bl = 1 <= foundCityAction22 ? foundCityAction22 < 9 : false;
            if (bl) {
                bestCityLocation = bestTilesInfo.getBestTile();
            }
        }
        if (bestCityLocation == null) {
            Object v16;
            Iterable $this$maxByOrNull$iv = unit.getCiv().getCities();
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v16 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v16 = maxElem$iv;
                } else {
                    City it = (City)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = SpecificUnitAutomation.automateSettlerActions$getFrontierScore(unit, it);
                    do {
                        Object e$iv = iterator$iv.next();
                        City it3 = (City)e$iv;
                        $i$a$-maxByOrNull-SpecificUnitAutomation$automateSettlerActions$frontierCity$1 = false;
                        int v$iv = SpecificUnitAutomation.automateSettlerActions$getFrontierScore(unit, it3);
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v16 = maxElem$iv;
                }
            }
            City frontierCity = v16;
            if (frontierCity != null && SpecificUnitAutomation.automateSettlerActions$getFrontierScore(unit, frontierCity) > 0 && unit.getMovement().canReach(frontierCity.getCenterTile())) {
                unit.getMovement().headTowards(frontierCity.getCenterTile());
            }
            if (UnitAutomation.INSTANCE.tryExplore$core(unit)) {
                return;
            }
            UnitAutomation.wander$default(UnitAutomation.INSTANCE, unit, false, dangerousTiles, 2, null);
            return;
        }
        UnitAction unitAction = foundCityAction = UnitActionsFromUniques.INSTANCE.getFoundCityAction$core(unit, bestCityLocation);
        if ((unitAction != null ? unitAction.getAction() : null) == null) {
            if (unit.hasMovement() && !unit.getCiv().isOneCityChallenger()) {
                throw new Exception("City within distance");
            }
            return;
        }
        boolean bl = shouldSettle = Intrinsics.areEqual(unit.getTile(), bestCityLocation) && unit.hasMovement();
        if (shouldSettle) {
            foundCityAction.getAction().invoke();
            return;
        }
        if (CivilianUnitAutomation.INSTANCE.tryRunAwayIfNeccessary(unit)) {
            return;
        }
        unit.getMovement().headTowards(bestCityLocation);
        boolean bl2 = shouldSettleNow = Intrinsics.areEqual(unit.getTile(), bestCityLocation) && unit.hasMovement();
        if (shouldSettleNow) {
            foundCityAction.getAction().invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean automateImprovementPlacer(@NotNull MapUnit unit) {
        Object object;
        Object v2;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Unique unique = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(unit, UniqueType.ConstructImprovementInstantly, null, false, 6, null));
        if (unique == null) {
            return false;
        }
        Unique improvementBuildingUnique = unique;
        String improvementName = improvementBuildingUnique.getParams().get(0);
        TileImprovement tileImprovement = unit.getCiv().getGameInfo().getRuleset().getTileImprovements().get(improvementName);
        if (tileImprovement == null) {
            return false;
        }
        TileImprovement improvement = tileImprovement;
        Iterable $this$maxByOrNull$iv = improvement;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                Stats.StatValuePair it = (Stats.StatValuePair)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Stats.StatValuePair it2 = (Stats.StatValuePair)e$iv;
                    boolean bl2 = false;
                    float v$iv = it2.getValue();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        if ((object = (Stats.StatValuePair)v2) == null || (object = ((Stats.StatValuePair)object).getKey()) == null) {
            object = Stat.Culture;
        }
        Object relatedStat = object;
        Iterable $this$sortedByDescending$iv = unit.getCiv().getCities();
        boolean $i$f$sortedByDescending = false;
        List<City> citiesByStatBoost = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator((Stat)relatedStat){
            final /* synthetic */ Stat $relatedStat$inlined;
            {
                this.$relatedStat$inlined = stat;
            }

            public final int compare(T a, T b) {
                City it = (City)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getCityStats().getStatPercentBonusTree().getTotalStats().get(this.$relatedStat$inlined));
                it = (City)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getCityStats().getStatPercentBonusTree().getTotalStats().get(this.$relatedStat$inlined)));
            }
        });
        Collection<Terrain> collection = unit.getCiv().getGameInfo().getRuleset().getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        double averageTerrainStatsValue = SequencesKt.averageOfFloat(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), SpecificUnitAutomation::automateImprovementPlacer$lambda$2), arg_0 -> SpecificUnitAutomation.automateImprovementPlacer$lambda$3(unit, arg_0)));
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        for (City city : citiesByStatBoost) {
            Object v7;
            block17: {
                void $this$firstOrNull$iv;
                List pathToCity;
                Sequence<Tile> applicableTiles = SequencesKt.filter(city.getWorkableTiles(), arg_0 -> SpecificUnitAutomation.automateImprovementPlacer$lambda$4(improvementName, unit, improvement, averageTerrainStatsValue, arg_0));
                if (SequencesKt.none(applicableTiles) || (pathToCity = UnitMovement.getShortestPath$default(unit.getMovement(), city.getCenterTile(), false, 2, null)).isEmpty()) continue;
                if (pathToCity.size() > 2 && !Intrinsics.areEqual(unit.getTile().getCity(), city)) {
                    boolean enemyUnitsNearby;
                    block16: {
                        boolean bl;
                        Sequence<Tile> $this$any$iv = unit.getTile().getTilesInDistance(5);
                        boolean $i$f$any = false;
                        Iterator<Tile> iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            boolean bl3;
                            block15: {
                                Tile element$iv;
                                Tile tileNearby = element$iv = iterator2.next();
                                boolean bl32 = false;
                                Sequence<MapUnit> $this$any$iv2 = tileNearby.getUnits();
                                boolean $i$f$any2 = false;
                                Iterator<MapUnit> iterator3 = $this$any$iv2.iterator();
                                while (iterator3.hasNext()) {
                                    MapUnit element$iv2;
                                    MapUnit unitOnTileNearby = element$iv2 = iterator3.next();
                                    boolean bl4 = false;
                                    if (!(unitOnTileNearby.isMilitary() && unitOnTileNearby.getCiv().isAtWarWith(unit.getCiv()))) continue;
                                    bl3 = true;
                                    break block15;
                                }
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block16;
                        }
                        bl = enemyUnitsNearby = false;
                    }
                    if (unit.getTile().getMilitaryUnit() == null && enemyUnitsNearby) {
                        return true;
                    }
                    unit.getMovement().headTowards(city.getCenterTile());
                    return true;
                }
                Sequence<Tile> $this$sortedByDescending$iv2 = applicableTiles;
                boolean $i$f$sortedByDescending2 = false;
                $this$sortedByDescending$iv2 = SequencesKt.sortedWith($this$sortedByDescending$iv2, new Comparator(unit, localUniqueCache){
                    final /* synthetic */ MapUnit $unit$inlined;
                    final /* synthetic */ LocalUniqueCache $localUniqueCache$inlined;
                    {
                        this.$unit$inlined = mapUnit;
                        this.$localUniqueCache$inlined = localUniqueCache;
                    }

                    public final int compare(T a, T b) {
                        Tile it = (Tile)b;
                        boolean bl = false;
                        Comparable comparable = Float.valueOf(Automation.INSTANCE.rankTile$core(it, this.$unit$inlined.getCiv(), this.$localUniqueCache$inlined));
                        it = (Tile)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(Automation.INSTANCE.rankTile$core(it, this.$unit$inlined.getCiv(), this.$localUniqueCache$inlined)));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!unit.getMovement().canReach(it)) continue;
                    v7 = element$iv;
                    break block17;
                }
                v7 = null;
            }
            Tile tile = v7;
            if (tile == null) continue;
            Tile chosenTile = tile;
            Tile unitTileBeforeMovement = unit.getCurrentTile();
            unit.getMovement().headTowards(chosenTile);
            if (Intrinsics.areEqual(unit.getCurrentTile(), chosenTile)) {
                boolean bl = unit.getCurrentTile().isPillaged() ? UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.Repair) : UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.CreateImprovement);
                return true;
            }
            return !Intrinsics.areEqual(unitTileBeforeMovement, unit.getCurrentTile());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean conductTradeMission(@NotNull MapUnit unit) {
        Object v1;
        block6: {
            void $this$sortedBy$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            IsPartOfGameInfoSerialization it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(unit, "unit");
            boolean conductedTradeMission = UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.ConductTradeMission);
            if (conductedTradeMission) {
                return true;
            }
            Iterable iterable = unit.getCiv().getGameInfo().getCivilizations();
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Civilization)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it, unit.getCiv()) && !unit.getCiv().isAtWarWith((Civilization)it) && it.isCityState() && !((Collection)it.getCities()).isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMapSequence = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Civilization)element$iv$iv;
                boolean bl = false;
                Sequence<Tile> list$iv$iv = it.getCities().get(0).getTiles();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!unit.getCiv().hasExplored((Tile)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List relevantTiles = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$unit$inlined.getCurrentTile().aerialDistanceTo(it));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getCurrentTile().aerialDistanceTo(it));
                }
            });
            Iterable $this$firstOrNull$iv = relevantTiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                List path;
                int n;
                Tile tile = (Tile)element$iv;
                boolean bl = false;
                boolean bl2 = !UnitMovement.canPassThrough$default(unit.getMovement(), tile, false, 2, null) ? false : (1 <= (n = (path = UnitMovement.getShortestPath$default(unit.getMovement(), tile, false, 2, null)).size()) ? n < 11 : false);
                if (!bl2) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        Tile closestCityStateTile = v1;
        if (closestCityStateTile == null) {
            return false;
        }
        Tile unitTileBeforeMovement = unit.getCurrentTile();
        unit.getMovement().headTowards(closestCityStateTile);
        return !Intrinsics.areEqual(unitTileBeforeMovement, unit.getCurrentTile());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean speedupWonderConstruction(@NotNull MapUnit unit) {
        City city;
        Object v0;
        void $this$minByOrNull$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object city2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Iterable $this$filter$iv = unit.getCiv().getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            city2 = (City)element$iv$iv;
            boolean bl = false;
            if (!(((City)city2).getPopulation().getPopulation() >= 3 && (UnitMovement.canMoveTo$default(unit.getMovement(), ((City)city2).getCenterTile(), false, false, false, 14, null) || Intrinsics.areEqual(unit.getCurrentTile(), ((City)city2).getCenterTile())) && INSTANCE.getWonderThatWouldBenefitFromBeingSpedUp((City)city2) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        city2 = $this$forEach$iv$iv$iv.iterator();
        while (city2.hasNext()) {
            Pair<City, Integer> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = city2.next();
            boolean bl = false;
            City city3 = (City)element$iv$iv;
            boolean bl2 = false;
            List path = UnitMovement.getShortestPath$default(unit.getMovement(), city3.getCenterTile(), false, 2, null);
            if ((CollectionsKt.any(path) && path.size() <= 5 ? TuplesKt.to(city3, path.size()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Pair it = (Pair)minElem$iv;
                boolean bl = false;
                int minValue$iv = ((Number)it.getSecond()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-minByOrNull-SpecificUnitAutomation$speedupWonderConstruction$nearbyCityWithAvailableWonders$3 = false;
                    int v$iv = ((Number)it2.getSecond()).intValue();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Pair pair = v0;
        if (pair == null || (city = (City)pair.getFirst()) == null) {
            return false;
        }
        City nearbyCityWithAvailableWonders = city;
        if (Intrinsics.areEqual(unit.getCurrentTile(), nearbyCityWithAvailableWonders.getCenterTile())) {
            Building building = this.getWonderThatWouldBenefitFromBeingSpedUp(nearbyCityWithAvailableWonders);
            Intrinsics.checkNotNull(building);
            Building wonderToHurry = building;
            nearbyCityWithAvailableWonders.getCityConstructions().getConstructionQueue().add(0, wonderToHurry.getName());
            return UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.HurryBuilding) || UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.HurryWonder);
        }
        Tile tileBeforeMoving = unit.getTile();
        unit.getMovement().headTowards(nearbyCityWithAvailableWonders.getCenterTile());
        return !Intrinsics.areEqual(tileBeforeMoving, unit.getCurrentTile());
    }

    @Readonly
    private final Building getWonderThatWouldBenefitFromBeingSpedUp(City city) {
        Sequence<Building> $this$sortedBy$iv = SequencesKt.filter(city.getCityConstructions().getBuildableBuildings$core(), arg_0 -> SpecificUnitAutomation.getWonderThatWouldBenefitFromBeingSpedUp$lambda$0(city, arg_0));
        boolean $i$f$sortedBy = false;
        return SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(city){
            final /* synthetic */ City $city$inlined;
            {
                this.$city$inlined = city;
            }

            public final int compare(T a, T b) {
                Building it = (Building)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(-CityConstructions.getRemainingWork$default(this.$city$inlined.getCityConstructions(), it.getName(), false, 2, null));
                it = (Building)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, -CityConstructions.getRemainingWork$default(this.$city$inlined.getCityConstructions(), it.getName(), false, 2, null));
            }
        }));
    }

    public final void automateAddInCapital(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (Civilization.getCapital$default(unit.getCiv(), false, 1, null) == null) {
            return;
        }
        City city = Civilization.getCapital$default(unit.getCiv(), false, 1, null);
        Intrinsics.checkNotNull(city);
        Tile capitalTile = city.getCenterTile();
        if (unit.getMovement().canReach(capitalTile)) {
            unit.getMovement().headTowards(capitalTile);
        }
        if (unit.getMovement().canUnitSwapTo(capitalTile)) {
            UnitMovement.swapMoveToTile$default(unit.getMovement(), capitalTile, false, 2, null);
        }
        if (Intrinsics.areEqual(unit.getTile(), capitalTile)) {
            UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.AddInCapital);
        }
    }

    private static final boolean automateCitadelPlacer$lambda$1(MapUnit $unit, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        DiplomacyManager diplomacyManager = $unit.getCiv().getDiplomacyManager(it);
        Intrinsics.checkNotNull(diplomacyManager);
        return diplomacyManager.hasModifier(DiplomaticModifiers.StealingTerritory);
    }

    private static final Iterable automateCitadelPlacer$lambda$2(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCities();
    }

    private static final Sequence automateCitadelPlacer$lambda$3(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTiles();
    }

    private static final boolean automateCitadelPlacer$lambda$4(MapUnit $unit, Tile it) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(it, "it");
            Sequence<Tile> $this$any$iv = it.getNeighbors();
            boolean $i$f$any = false;
            Iterator<Tile> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile tile = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual(tile.getOwner(), $unit.getCiv()))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final Sequence automateCitadelPlacer$lambda$5(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getNeighbors();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean automateCitadelPlacer$lambda$6(MapUnit $unit, Tile it) {
        Tile tile;
        Intrinsics.checkNotNullParameter(it, "it");
        if (!$unit.getCiv().getViewableTiles().contains(it)) return false;
        Sequence<Tile> $this$any$iv = it.getNeighbors();
        boolean $i$f$any = false;
        Iterator<Tile> iterator2 = $this$any$iv.iterator();
        do {
            Tile element$iv;
            if (!iterator2.hasNext()) return false;
            tile = element$iv = iterator2.next();
            boolean bl = false;
        } while (!Intrinsics.areEqual(tile.getOwner(), $unit.getCiv()));
        return true;
    }

    private static final boolean automateSettlerActions$lambda$0(MapUnit $unit, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.hasMovement() && Intrinsics.areEqual(it.getBaseUnit(), $unit.getBaseUnit());
    }

    @Readonly
    private static final boolean automateSettlerActions$isTileRankOK(HashSet<Tile> $dangerousTiles, MapUnit $unit, Map.Entry<Tile, Float> it) {
        if ($dangerousTiles.contains(it.getKey()) && !Intrinsics.areEqual(it.getKey(), $unit.getTile())) {
            return false;
        }
        int pathSize = UnitMovement.getShortestPath$default($unit.getMovement(), it.getKey(), false, 2, null).size();
        return 1 <= pathSize ? pathSize < 4 : false;
    }

    private static final boolean automateSettlerActions$lambda$3(CityLocationTileRanker.BestTilesToFoundCity $bestTilesInfo, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $bestTilesInfo.getBestTile() == null || ((Number)it.getValue()).floatValue() >= $bestTilesInfo.getBestTileRank() - (float)5;
    }

    @Readonly
    private static final int automateSettlerActions$getFrontierScore(MapUnit $unit, City city) {
        Sequence<Tile> $this$count$iv = city.getCenterTile().getTilesAtDistance(city.getCiv().getGameInfo().getRuleset().getModOptions().getConstants().getMinimalCityDistance() + 1);
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Tile> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Tile element$iv;
            Tile it = element$iv = iterator2.next();
            boolean bl = false;
            if (!it.canBeSettled($unit.getCiv()) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv;
    }

    private static final boolean automateImprovementPlacer$lambda$2(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == TerrainType.Land;
    }

    private static final float automateImprovementPlacer$lambda$3(MapUnit $unit, Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Automation.INSTANCE.rankStatsValue(it, $unit.getCiv());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean automateImprovementPlacer$lambda$4(String $improvementName, MapUnit $unit, TileImprovement $improvement, double $averageTerrainStatsValue, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isLand()) return false;
        if (it.getResource() != null) {
            if (!it.getTileResource().isImprovedBy($improvementName)) return false;
        }
        if (it.isCityCenter()) return false;
        if (!Intrinsics.areEqual($unit.getCurrentTile(), it)) {
            if (!UnitMovement.canMoveTo$default($unit.getMovement(), it, false, false, false, 14, null)) return false;
        }
        if (it.getImprovement() != null) {
            TileImprovement tileImprovement = it.getTileImprovement();
            Intrinsics.checkNotNull(tileImprovement);
            if (IHasUniques.hasUnique$default(tileImprovement, UniqueType.GreatImprovement, null, 2, null)) return false;
        }
        if (!it.getImprovementFunctions().canBuildImprovement($improvement, $unit.getCache().getState())) return false;
        if (!IHasUniques.hasUnique$default($improvement, UniqueType.GreatImprovement, null, 2, null)) return true;
        if (!((double)Automation.INSTANCE.rankStatsValue(it.getBaseTerrain().cloneStats(), $unit.getCiv()) > $averageTerrainStatsValue)) return false;
        return true;
    }

    private static final boolean getWonderThatWouldBenefitFromBeingSpedUp$lambda$0(City $city, Building building) {
        Intrinsics.checkNotNullParameter(building, "building");
        return building.isWonder() && !IHasUniques.hasUnique$default(building, UniqueType.CannotBeHurried, null, 2, null) && CityConstructions.turnsToConstruction$default($city.getCityConstructions(), building.getName(), false, 2, null) >= 5;
    }
}

