/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Timer;
import com.unciv.logic.GameInfo;
import com.unciv.models.UncivSound;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.YearTextUtil;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.victoryscreen.ReplayMap;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\nH\u0002J \u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020\u0001H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00150\u00150\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenReplay;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "finalTurn", "", "replayTimer", "Lcom/badlogic/gdx/utils/Timer$Task;", "header", "yearLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "slider", "Lcom/unciv/ui/components/widgets/UncivSlider;", "replayMap", "Lcom/unciv/ui/screens/victoryscreen/ReplayMap;", "playImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "pauseImage", "playPauseButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "kotlin.jvm.PlatformType", "togglePause", "", "restartTimer", "resetTimer", "sliderChanged", "value", "", "updateReplayTable", "turn", "activated", "index", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "deactivated", "getFixedContent", "core"})
public final class VictoryScreenReplay
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final GameInfo gameInfo;
    private final int finalTurn;
    @Nullable
    private Timer.Task replayTimer;
    @NotNull
    private final Table header;
    @NotNull
    private final Label yearLabel;
    @NotNull
    private final UncivSlider slider;
    @NotNull
    private final ReplayMap replayMap;
    @NotNull
    private final Image playImage;
    @NotNull
    private final Image pauseImage;
    @NotNull
    private final Container<Image> playPauseButton;

    public VictoryScreenReplay(@NotNull WorldScreen worldScreen) {
        Container<Image> container;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.gameInfo = worldScreen.getGameInfo();
        this.finalTurn = this.gameInfo.getTurns();
        this.header = new Table();
        this.yearLabel = Scene2dExtensionsKt.toLabel("");
        this.playImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/ForwardArrow", null, 2, null);
        this.pauseImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Pause", null, 2, null);
        this.playPauseButton = new Container<Actor>((Actor)this.pauseImage);
        int firstTurn = this.gameInfo.getHistoryStartTurn();
        float maxSliderPercent = worldScreen.isPortrait() ? 0.75f : 0.5f;
        float sliderWidth = RangesKt.coerceAtLeast(RangesKt.coerceAtMost(RangesKt.coerceAtMost((float)(this.finalTurn - firstTurn) * 15.0f + 60.0f, worldScreen.getStage().getWidth() * maxSliderPercent), worldScreen.getStage().getWidth() - 190.0f), 120.0f);
        this.slider = new UncivSlider(firstTurn, this.finalTurn, 1.0f, false, false, firstTurn, UncivSound.Companion.getSilent(), UncivSlider.TipType.None, null, new Function1<Float, Unit>((Object)this){

            @Override
            public final void invoke(float p0) {
                ((VictoryScreenReplay)this.receiver).sliderChanged(p0);
            }
        }, 280, null);
        this.replayMap = new ReplayMap(this.gameInfo.getTileMap(), worldScreen.getViewingCiv(), worldScreen.getStage().getWidth() - (float)50, worldScreen.getStage().getHeight() - (float)250);
        Scene2dExtensionsKt.setSize(this.playImage, 24.0f);
        Scene2dExtensionsKt.setSize(this.pauseImage, 24.0f);
        Container<Image> $this$_init__u24lambda_u240 = container = this.playPauseButton;
        boolean bl = false;
        $this$_init__u24lambda_u240.setSize(26.0f, 26.0f);
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u240, new Function0<Unit>((Object)this){

            public final void invoke() {
                VictoryScreenReplay.access$togglePause((VictoryScreenReplay)this.receiver);
            }
        });
        this.yearLabel.setAlignment(16);
        ActivationExtensionsKt.onClick(this.yearLabel, () -> VictoryScreenReplay._init_$lambda$1(this));
        this.header.defaults().space(15.0f).fillX().padTop(15.0f);
        this.header.add((Actor)this.yearLabel).minWidth(80.0f).right();
        this.header.add((Actor)this.slider).width(sliderWidth);
        this.header.add((Actor)this.playPauseButton).minWidth(80.0f);
        this.add((Actor)this.replayMap).pad(10.0f);
    }

    private final void togglePause() {
        if (this.replayTimer == null) {
            this.restartTimer();
        } else {
            this.resetTimer();
        }
    }

    private final void restartTimer() {
        Timer.Task task2 = this.replayTimer;
        if (task2 != null) {
            task2.cancel();
        }
        int firstTurn = (int)this.slider.getValue();
        this.replayTimer = Timer.schedule(new Timer.Task(firstTurn, this){
            private int nextTurn;
            final /* synthetic */ VictoryScreenReplay this$0;
            {
                this.this$0 = $receiver;
                this.nextTurn = $firstTurn;
            }

            public void run() {
                int n = this.nextTurn;
                this.nextTurn = n + 1;
                VictoryScreenReplay.access$updateReplayTable(this.this$0, n);
            }
        }, 0.0f, 0.1f, this.finalTurn - firstTurn);
        this.playPauseButton.setActor((Image)((Actor)this.pauseImage));
    }

    private final void resetTimer() {
        Timer.Task task2 = this.replayTimer;
        if (task2 != null) {
            task2.cancel();
        }
        this.replayTimer = null;
        this.playPauseButton.setActor((Image)((Actor)this.playImage));
    }

    private final void sliderChanged(float value) {
        this.resetTimer();
        this.updateReplayTable((int)value);
    }

    private final void updateReplayTable(int turn) {
        int year2 = this.gameInfo.getYear(turn - this.finalTurn);
        this.yearLabel.setText(YearTextUtil.INSTANCE.toYearText(year2, this.gameInfo.getCurrentPlayerCiv().isLongCountDisplay()) + " / " + TranslationsKt.tr(turn) + '\u23f3');
        this.slider.setValue(turn);
        this.replayMap.update(turn);
        if (turn == this.finalTurn) {
            this.resetTimer();
        }
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.restartTimer();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.resetTimer();
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.header;
    }

    private static final Unit _init_$lambda$1(VictoryScreenReplay this$0) {
        this$0.updateReplayTable(this$0.gameInfo.getHistoryStartTurn());
        this$0.restartTimer();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateReplayTable(VictoryScreenReplay $this, int turn) {
        $this.updateReplayTable(turn);
    }

    public static final /* synthetic */ void access$togglePause(VictoryScreenReplay $this) {
        $this.togglePause();
    }
}

