# ========================================================================
#
#  Copyright NumFOCUS
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0.txt
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
# ========================================================================


def _get_pep386version():
    """Uses configured CMake version variable to construct a pep 386 compliant version string."""

    sitk_major = "2"
    sitk_minor = "5"
    sitk_patch = "3"
    sitk_tweak = ""
    sitk_rc = ""
    sitk_post = ""
    sitk_dev = ""
    sitk_hash = "31617"

    version = sitk_major + "." + sitk_minor

    if sitk_patch:
        version += "." + sitk_patch
        if sitk_tweak:
            version += "." + sitk_tweak

    if sitk_rc:
        version += sitk_rc

    if sitk_post:
        version += ".post" + sitk_post
    elif sitk_dev:
        version += ".dev" + sitk_dev

    # Local Version Identifier
    if sitk_hash and "ON" not in ['1', 'ON']:
        version += "+g" + sitk_hash

    return version


__version__ = _get_pep386version()
