---
allowed-tools: Read, Write, Edit, Glob
argument-hint: [capture-type] | --project-learnings | --implementation-corrections | --structure-insights | --workflow-improvements
description: Capture and document session learnings with automatic knowledge integration and memory updates
---

# Session Learning Capture

Capture and integrate session learnings into project memory and knowledge base: **$ARGUMENTS**

## Current Learning Context

- Session duration: Current Claude Code session learning opportunities
- Memory files: !`find . -name "CLAUDE*.md" | wc -l` available memory files for knowledge integration
- Project complexity: Assessment of project structure and documentation completeness
- Learning patterns: Identification of knowledge gaps and correction opportunities

## Task

Execute comprehensive learning capture with automatic knowledge integration:

**Capture Type**: Use $ARGUMENTS to focus on project learnings, implementation corrections, structure insights, or workflow improvements

**Learning Capture Framework**:
1. **Learning Identification** - Detect new project knowledge, identify implementation corrections, recognize structural insights, note workflow discoveries
2. **Knowledge Classification** - Categorize learning type, assess importance level, determine integration location, evaluate reusability potential
3. **Context Analysis** - Analyze session context, identify triggering conditions, assess knowledge applicability, determine documentation needs
4. **Integration Planning** - Select appropriate memory files, determine update strategy, maintain consistency, preserve existing knowledge
5. **Memory Updates** - Update CLAUDE.md files, enhance documentation, improve workflows, strengthen knowledge base
6. **Validation Process** - Verify accuracy of captured knowledge, ensure integration quality, validate accessibility, confirm usefulness

**Advanced Features**: Automated learning detection, intelligent categorization, context-aware integration, knowledge graph enhancement, version control integration.

**Quality Assurance**: Learning accuracy validation, integration consistency, accessibility optimization, knowledge retrieval efficiency.

**Output**: Comprehensive learning integration with updated memory files, enhanced documentation, improved workflows, and validated knowledge base.