"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirListCreateCommand = void 0;
exports.createList = createList;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
async function createList(draupnir, info, _keywords, _rest, shortcode, aliasName) {
    const newList = await draupnir.policyRoomManager.createPolicyRoom(shortcode, 
    // avoids inviting ourself and setting 50 as our own powerlevel
    [info.commandSender].filter((sender) => sender !== draupnir.clientUserID), {
        room_alias_name: aliasName,
    });
    if ((0, matrix_protection_suite_1.isError)(newList)) {
        return newList;
    }
    const watchResult = await draupnir.protectedRoomsSet.watchedPolicyRooms.watchPolicyRoomDirectly(newList.ok);
    if ((0, matrix_protection_suite_1.isError)(watchResult)) {
        return watchResult;
    }
    const protectResult = await draupnir.protectedRoomsSet.protectedRoomsManager.addRoom(newList.ok);
    if ((0, matrix_protection_suite_1.isError)(protectResult)) {
        return protectResult;
    }
    return newList;
}
exports.DraupnirListCreateCommand = (0, interface_manager_1.describeCommand)({
    summary: "Create a new Policy Room which can be used to ban users, rooms and servers from your protected rooms",
    parameters: (0, interface_manager_1.tuple)({
        name: "shortcode",
        acceptor: interface_manager_1.StringPresentationType,
    }, {
        name: "alias name",
        acceptor: interface_manager_1.StringPresentationType,
    }),
    executor: createList,
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirListCreateCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=CreateBanListCommand.js.map