"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2020 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Healthz = void 0;
const http = __importStar(require("http"));
const matrix_bot_sdk_1 = require("matrix-bot-sdk");
// allowed to use the global configuration since this is only intended to be used by `src/index.ts`.
class Healthz {
    constructor(config) {
        this.config = config;
        this.healthCode = this.config.health.healthz.unhealthyStatus;
    }
    set isHealthy(val) {
        this.healthCode = val
            ? this.config.health.healthz.healthyStatus
            : this.config.health.healthz.unhealthyStatus;
    }
    get isHealthy() {
        return this.healthCode === this.config.health.healthz.healthyStatus;
    }
    listen() {
        const server = http.createServer((req, res) => {
            res.writeHead(this.healthCode);
            res.end(`health code: ${this.healthCode}`);
        });
        server.listen(this.config.health.healthz.port, this.config.health.healthz.address, () => {
            matrix_bot_sdk_1.LogService.info("Healthz", `Listening for health requests on ${this.config.health.healthz.address}:${this.config.health.healthz.port}`);
        });
    }
}
exports.Healthz = Healthz;
//# sourceMappingURL=healthz.js.map