/* tslint:disable */
/* eslint-disable */

/* auto-generated by NAPI-RS */

/**
 * An encryption algorithm to be used to encrypt messages sent to a
 * room.
 */
export const enum EncryptionAlgorithm {
  /** Olm version 1 using Curve25519, AES-256, and SHA-256. */
  OlmV1Curve25519AesSha2 = 0,
  /** Megolm version 1 using AES-256 and SHA-256. */
  MegolmV1AesSha2 = 1
}
/**
 * Take a look at [`matrix_sdk_common::deserialized_responses::ShieldState`]
 * for more info.
 */
export const enum ShieldColor {
  Red = 0,
  Grey = 1,
  None = 2
}
/** Who can see a room's history. */
export const enum HistoryVisibility {
  /**
   * Previous events are accessible to newly joined members from
   * the point they were invited onwards.
   *
   * Events stop being accessible when the member's state changes
   * to something other than *invite* or *join*.
   */
  Invited = 0,
  /**
   * Previous events are accessible to newly joined members from
   * the point they joined the room onwards.
   *
   * Events stop being accessible when the member's state changes
   * to something other than *join*.
   */
  Joined = 1,
  /**
   * Previous events are always accessible to newly joined members.
   *
   * All events in the room are accessible, even those sent when
   * the member was not a part of the room.
   */
  Shared = 2,
  /**
   * All events while this is the `HistoryVisibility` value may be
   * shared by any participating homeserver with anyone, regardless
   * of whether they have ever joined the room.
   */
  WorldReadable = 3
}
/** The basic key algorithm names in the specification. */
export const enum DeviceKeyAlgorithmName {
  /** The Ed25519 signature algorithm. */
  Ed25519 = 0,
  /** The Curve25519 ECDH algorithm. */
  Curve25519 = 1,
  /**
   * The Curve25519 ECDH algorithm, but the key also contains
   * signatures.
   */
  SignedCurve25519 = 2,
  /** An unknown device key algorithm. */
  Unknown = 3
}
/** Represents the type of store an `OlmMachine` can use. */
export const enum StoreType {
  /** Use `matrix-sdk-sqlite`. */
  Sqlite = 0
}
/** Represent the type of a request. */
export const enum RequestType {
  /** Represents a `KeysUploadRequest`. */
  KeysUpload = 0,
  /** Represents a `KeysQueryRequest`. */
  KeysQuery = 1,
  /** Represents a `KeysClaimRequest`. */
  KeysClaim = 2,
  /** Represents a `ToDeviceRequest`. */
  ToDevice = 3,
  /** Represents a `SignatureUploadRequest`. */
  SignatureUpload = 4,
  /** Represents a `RoomMessageRequest`. */
  RoomMessage = 5,
  /** Represents a `KeysBackupRequest`. */
  KeysBackup = 6
}
/** The result of a signature check. */
export const enum SignatureState {
  /** The signature is missing. */
  Missing = 0,
  /** The signature is invalid. */
  Invalid = 1,
  /**
   * The signature is valid but the device or user identity that created the
   * signature is not trusted.
   */
  ValidButNotTrusted = 2,
  /**
   * The signature is valid and the device or user identity that created the
   * signature is trusted.
   */
  ValidAndTrusted = 3
}
/** Get the versions of the Rust libraries we are using. */
export function getVersions(): Versions
/**
 * A type to encrypt and to decrypt anything that can fit in an
 * `Uint8Array`, usually big buffer.
 */
export class Attachment {
  /**
   * Encrypt the content of the `Uint8Array`.
   *
   * It produces an `EncryptedAttachment`, which can be used to
   * retrieve the media encryption information, or the encrypted
   * data.
   */
  static encrypt(array: Uint8Array): EncryptedAttachment
  /**
   * Decrypt an `EncryptedAttachment`.
   *
   * The encrypted attachment can be created manually, or from the
   * `encrypt` method.
   *
   * **Warning**: The encrypted attachment can be used only
   * **once**! The encrypted data will still be present, but the
   * media encryption info (which contain secrets) will be
   * destroyed. It is still possible to get a JSON-encoded backup
   * by calling `EncryptedAttachment.mediaEncryptionInfo`.
   */
  static decrypt(attachment: EncryptedAttachment): Uint8Array
}
/** An encrypted attachment, usually created from `Attachment.encrypt`. */
export class EncryptedAttachment {
  /** The actual encrypted data. */
  encryptedData: Uint8Array
  /**
   * Create a new encrypted attachment manually.
   *
   * It needs encrypted data, stored in an `Uint8Array`, and a
   * [media encryption
   * information](https://docs.rs/matrix-sdk-crypto/latest/matrix_sdk_crypto/struct.MediaEncryptionInfo.html),
   * as a JSON-encoded string.
   *
   * The media encryption information aren't stored as a string:
   * they are parsed, validated and fully deserialized.
   *
   * See [the specification to learn
   * more](https://spec.matrix.org/unstable/client-server-api/#extensions-to-mroommessage-msgtypes).
   */
  constructor(encryptedData: Uint8Array, mediaEncryptionInfo: string)
  /**
   * Return the media encryption info as a JSON-encoded string. The
   * structure is fully valid.
   *
   * If the media encryption info have been consumed already, it
   * will return `null`.
   */
  get mediaEncryptionInfo(): string | null
  /**
   * Check whether the media encryption info has been consumed by
   * `Attachment.decrypt` already.
   */
  get hasMediaEncryptionInfoBeenConsumed(): boolean
}
/** The private part of the backup key, the one used for recovery. */
export class BackupDecryptionKey {
  /** Create a new random [`BackupDecryptionKey`]. */
  static createRandomKey(): BackupDecryptionKey
  /** Try to create a [`BackupDecryptionKey`] from a base 64 encoded string. */
  static fromBase64(key: string): BackupDecryptionKey
  /** Convert the recovery key to a base 64 encoded string. */
  toBase64(): string
  /** Get the public part of the backup key. */
  get megolmV1PublicKey(): MegolmV1BackupKey
  /**
   * Try to decrypt a message that was encrypted using the public part of the
   * backup key.
   */
  decryptV1(ephemeralKey: string, mac: string, ciphertext: string): string
}
/** The public part of the backup key. */
export class MegolmV1BackupKey {
  /** The actual base64 encoded public key. */
  get publicKeyBase64(): string
  /** Get the full name of the backup algorithm this backup key supports. */
  get algorithm(): string
}
/** Struct holding the number of room keys we have. */
export class RoomKeyCounts {
  /** The total number of room keys. */
  total: number
  /** The number of backed up room keys. */
  backedUp: number
}
/** Stored versions of the backup keys. */
export class BackupKeys {
  /** The key used to decrypt backed up room keys, encoded as base64 */
  decryptionKeyBase64?: string
  /** The version that we are using for backups. */
  backupVersion?: string
}
/**
 * Settings for an encrypted room.
 *
 * This determines the algorithm and rotation periods of a group
 * session.
 */
export class EncryptionSettings {
  /** The encryption algorithm that should be used in the room. */
  algorithm: EncryptionAlgorithm
  /**
   * How long the session should be used before changing it,
   * expressed in microseconds.
   */
  rotationPeriod: bigint
  /** How many messages should be sent before changing the session. */
  rotationPeriodMessages: bigint
  /**
   * The history visibility of the room when the session was
   * created.
   */
  historyVisibility: HistoryVisibility
  /**
   * Should untrusted devices receive the room key, or should they be
   * excluded from the conversation.
   */
  onlyAllowTrustedDevices: boolean
  /** Create a new `EncryptionSettings` with default values. */
  constructor()
}
/**
 * Take a look at [`matrix_sdk_common::deserialized_responses::ShieldState`]
 * for more info.
 */
export class ShieldState {
  color: ShieldColor
  message?: string
}
/**
 * A Matrix [user ID].
 *
 * [user ID]: https://spec.matrix.org/v1.2/appendices/#user-identifiers
 */
export class UserId {
  /** Parse/validate and create a new `UserId`. */
  constructor(id: string)
  /** Returns the user's localpart. */
  get localpart(): string
  /** Returns the server name of the user ID. */
  get serverName(): ServerName
  /**
   * Whether this user ID is a historical one.
   *
   * A historical user ID is one that doesn't conform to the latest
   * specification of the user ID grammar but is still accepted
   * because it was previously allowed.
   */
  isHistorical(): boolean
  /** Return the user ID as a string. */
  toString(): string
}
/**
 * A Matrix device ID.
 *
 * Device identifiers in Matrix are completely opaque character
 * sequences. This type is provided simply for its semantic value.
 */
export class DeviceId {
  /** Create a new `DeviceId`. */
  constructor(id: string)
  /** Return the device ID as a string. */
  toString(): string
}
/**
 * A Matrix device key ID.
 *
 * A key algorithm and a device ID, combined with a ‘:’.
 */
export class DeviceKeyId {
  /** Parse/validate and create a new `DeviceKeyId`. */
  constructor(id: string)
  /** Returns key algorithm of the device key ID. */
  get algorithm(): DeviceKeyAlgorithm
  /** Returns device ID of the device key ID. */
  get deviceId(): DeviceId
  /** Return the device key ID as a string. */
  toString(): string
}
/** The basic key algorithms in the specification. */
export class DeviceKeyAlgorithm {
  /**
   * Read the device key algorithm's name. If the name is
   * `Unknown`, one may be interested by the `to_string` method to
   * read the original name.
   */
  get name(): DeviceKeyAlgorithmName
  /** Return the device key algorithm as a string. */
  toString(): string
}
/**
 * A Matrix [room ID].
 *
 * [room ID]: https://spec.matrix.org/v1.2/appendices/#room-ids-and-event-ids
 */
export class RoomId {
  /** Parse/validate and create a new `RoomId`. */
  constructor(id: string)
  /** Return the room ID as a string. */
  toString(): string
  /** Returns the server name of the room ID. */
  get serverName(): ServerName
}
/**
 * A Matrix-spec compliant [server name].
 *
 * It consists of a host and an optional port (separated by a colon if
 * present).
 *
 * [server name]: https://spec.matrix.org/v1.2/appendices/#server-name
 */
export class ServerName {
  /** Parse/validate and create a new `ServerName`. */
  constructor(name: string)
  /**
   * Returns the host of the server name.
   *
   * That is: Return the part of the server before `:<port>` or the
   * full server name if there is no port.
   */
  get host(): string
  /** Returns the port of the server name if any. */
  get port(): number | null
  /**
   * Returns true if and only if the server name is an IPv4 or IPv6
   * address.
   */
  isIpLiteral(): boolean
}
/**
 * State machine implementation of the Olm/Megolm encryption protocol
 * used for Matrix end to end encryption.
 */
export class OlmMachine {
  /**
   * Create a new `OlmMachine` asynchronously.
   *
   * The persistence of the encryption keys and all the inner
   * objects are controlled by the `store_path` argument.
   *
   * # Arguments
   *
   * * `user_id`, the unique ID of the user that owns this machine.
   * * `device_id`, the unique id of the device that owns this machine.
   * * `store_path`, the path to a directory where the state of the machine
   *   should be persisted; if not set, the created machine will keep the
   *   encryption keys only in memory, and once the object is dropped, the
   *   keys will be lost.
   * * `store_passphrase`, the passphrase that should be used to encrypt the
   *   data at rest in the store. **Warning**, if no passphrase is given, the
   *   store and all its data will remain unencrypted. This argument is
   *   ignored if `store_path` is not set.
   */
  static initialize(userId: UserId, deviceId: DeviceId, storePath?: string | undefined | null, storePassphrase?: string | undefined | null, storeType?: StoreType | undefined | null): Promise<OlmMachine>
  /**
   * It's not possible to construct an `OlmMachine` with its
   * constructor because building an `OlmMachine` is
   * asynchronous. Please use the `finalize` method.
   */
  constructor()
  /** The unique user ID that owns this `OlmMachine` instance. */
  get userId(): UserId
  /** The unique device ID that identifies this `OlmMachine`. */
  get deviceId(): DeviceId
  /** Get the public parts of our Olm identity keys. */
  get identityKeys(): IdentityKeys
  /**
   * Handle a to-device and one-time key counts from a sync response.
   *
   * This will decrypt and handle to-device events returning the
   * decrypted versions of them, as a JSON-encoded string.
   *
   * To decrypt an event from the room timeline, please use
   * `decrypt_room_event`.
   *
   * # Arguments
   *
   * * `to_device_events`, the to-device events of the current sync response.
   * * `changed_devices`, the list of devices that changed in this sync
   *   response.
   * * `one_time_keys_count`, the current one-time keys counts that the sync
   *   response returned.
   */
  receiveSyncChanges(toDeviceEvents: string, changedDevices: DeviceLists, oneTimeKeyCounts: Record<string, number>, unusedFallbackKeys: Array<string>): Promise<string>
  /**
   * Get the outgoing requests that need to be sent out.
   *
   * This returns a list of `KeysUploadRequest`, or
   * `KeysQueryRequest`, or `KeysClaimRequest`, or
   * `ToDeviceRequest`, or `SignatureUploadRequest`, or
   * `RoomMessageRequest`. Those requests
   * need to be sent out to the server and the responses need to be
   * passed back to the state machine using `mark_request_as_sent`.
   */
  outgoingRequests(): Promise<Array<KeysUploadRequest | KeysQueryRequest | KeysClaimRequest | ToDeviceRequest | SignatureUploadRequest | RoomMessageRequest>>
  /**
   * Mark the request with the given request ID as sent.
   *
   * # Arguments
   *
   * * `request_id`, the unique ID of the request that was sent out. This is
   *   needed to couple the response with the now sent out request.
   * * `request_type`, the request type associated to the request ID.
   * * `response`, the response that was received from the server after the
   *   outgoing request was sent out.
   */
  markRequestAsSent(requestId: string, requestType: RequestType, response: string): Promise<boolean>
  /**
   * Get the a key claiming request for the user/device pairs that
   * we are missing Olm sessions for.
   *
   * Returns `null` if no key claiming request needs to be sent
   * out.
   *
   * Sessions need to be established between devices so group
   * sessions for a room can be shared with them.
   *
   * This should be called every time a group session needs to be
   * shared as well as between sync calls. After a sync some
   * devices may request room keys without us having a valid Olm
   * session with them, making it impossible to server the room key
   * request, thus it’s necessary to check for missing sessions
   * between sync as well.
   *
   * Note: Care should be taken that only one such request at a
   * time is in flight, e.g. using a lock.
   *
   * The response of a successful key claiming requests needs to be
   * passed to the `OlmMachine` with the `mark_request_as_sent`.
   *
   * # Arguments
   *
   * * `users`, the list of users that we should check if we lack a session
   *   with one of their devices. This can be an empty array or `null` when
   *   calling this method between sync requests.
   */
  getMissingSessions(users?: Array<UserId> | undefined | null): Promise<KeysClaimRequest | null>
  /**
   * Update the tracked users.
   *
   * This will mark users that weren’t seen before for a key query
   * and tracking.
   *
   * If the user is already known to the Olm machine it will not be
   * considered for a key query.
   *
   * # Arguments
   *
   * * `users`, an array over user IDs that should be marked for tracking.
   */
  updateTrackedUsers(users: Array<UserId>): Promise<void>
  /**
   * Get to-device requests to share a room key with users in a room.
   *
   * # Arguments
   *
   * * `room_id`, the room ID of the room where the room key will be used.
   * * `users`, the list of users that should receive the room key.
   * * `encryption_settings`, the encryption settings.
   */
  shareRoomKey(roomId: RoomId, users: Array<UserId>, encryptionSettings: EncryptionSettings): Promise<Array<ToDeviceRequest>>
  /**
   * Encrypt a JSON-encoded content for the given room.
   *
   * # Arguments
   *
   * * `room_id`, the ID of the room for which the message should be
   *   encrypted.
   * * `event_type`, the plaintext type of the event.
   * * `content`, the JSON-encoded content of the message that should be
   *   encrypted.
   */
  encryptRoomEvent(roomId: RoomId, eventType: string, content: string): Promise<string>
  /**
   * Decrypt an event from a room timeline.
   *
   * # Arguments
   *
   * * `event`, the event that should be decrypted.
   * * `room_id`, the ID of the room where the event was sent to.
   */
  decryptRoomEvent(event: string, roomId: RoomId): Promise<DecryptedRoomEvent>
  /**
   * Get the status of the private cross signing keys.
   *
   * This can be used to check which private cross signing keys we
   * have stored locally.
   */
  crossSigningStatus(): Promise<CrossSigningStatus>
  /**
   * Create a new cross signing identity and get the upload request
   * to push the new public keys to the server.
   *
   * Warning: This will delete any existing cross signing keys that
   * might exist on the server and thus will reset the trust
   * between all the devices.
   *
   * Uploading these keys will require user interactive auth.
   *
   * # Arguments
   *
   * * `reset`, whether the method should create a new identity or use the
   *   existing one during the request. If set to true, the request will
   *   attempt to upload a new identity. If set to false, the request will
   *   attempt to upload the existing identity. Since the uploading process
   *   requires user interactive authentication, which involves sending out
   *   the same request multiple times, setting this argument to false
   *   enables you to reuse the same request.
   */
  bootstrapCrossSigning(reset: boolean): Promise<void>
  /**
   * Sign the given message using our device key and if available
   * cross-signing master key.
   */
  sign(message: string): Promise<Signatures>
  /**
   * Store the backup decryption key in the crypto store.
   *
   * This is useful if the client wants to support gossiping of the backup
   * key.
   */
  saveBackupDecryptionKey(decryptionKey: BackupDecryptionKey, version: string): Promise<void>
  /** Get the backup keys we have saved in our store. */
  getBackupKeys(): Promise<BackupKeys>
  /**
   * Check if the given backup has been verified by us or by another of our
   * devices that we trust.
   *
   * The `backup_info` should be a stringified JSON object with the following
   * format:
   *
   * ```json
   * {
   *     "algorithm": "m.megolm_backup.v1.curve25519-aes-sha2",
   *     "auth_data": {
   *         "public_key":"XjhWTCjW7l59pbfx9tlCBQolfnIQWARoKOzjTOPSlWM",
   *         "signatures": {}
   *     }
   * }
   * ```
   */
  verifyBackup(backupInfo: string): Promise<SignatureVerification>
  /**
   * Activate the given backup key to be used with the given backup version.
   *
   * **Warning**: The caller needs to make sure that the given `BackupKey` is
   * trusted, otherwise we might be encrypting room keys that a malicious
   * party could decrypt.
   *
   * The [`OlmMachine::verify_backup`] method can be used to do so.
   */
  enableBackupV1(publicKeyBase64: string, version: string): Promise<void>
  /**
   * Are we able to encrypt room keys.
   *
   * This returns true if we have an active `BackupKey` and backup version
   * registered with the state machine.
   */
  isBackupEnabled(): Promise<boolean>
  /**
   * Disable and reset our backup state.
   *
   * This will remove any pending backup request, remove the backup key and
   * reset the backup state of each room key we have.
   */
  disableBackup(): Promise<void>
  /**
   * Encrypt a batch of room keys and return a request that needs to be sent
   * out to backup the room keys.
   */
  backupRoomKeys(): Promise<KeysBackupRequest | null>
  /**
   * Export room keys in unencrypted format for a given session_id.
   * This currently exports a json blob.
   */
  exportRoomKeysForSession(roomId: string, sessionId: string): Promise<string>
  /** Get the number of backed up room keys and the total number of room keys. */
  roomKeyCounts(): Promise<RoomKeyCounts>
  /**
   * Shut down the `OlmMachine`.
   *
   * The `OlmMachine` cannot be used after this method has been called,
   * otherwise it will panic.
   *
   * All associated resources will be closed too, like the crypto storage
   * connections.
   *
   * # Safety
   *
   * The caller is responsible to **not** use any objects that came from this
   * `OlmMachine` after this `close` method has been called.
   */
  close(): void
}
/**
 * Struct representing the state of our private cross signing keys,
 * it shows which private cross signing keys we have locally stored.
 */
export class CrossSigningStatus {
  /** Do we have the master key. */
  get hasMaster(): boolean
  /**
   * Do we have the self signing key, this one is necessary to sign
   * our own devices.
   */
  get hasSelfSigning(): boolean
  /**
   * Do we have the user signing key, this one is necessary to sign
   * other users.
   */
  get hasUserSigning(): boolean
}
/**
 * Data for a request to the `/keys/upload` API endpoint
 * ([specification]).
 *
 * Publishes end-to-end encryption keys for the device.
 *
 * [specification]: https://spec.matrix.org/unstable/client-server-api/#post_matrixclientv3keysupload
 */
export class KeysUploadRequest {
  /** The request ID. */
  readonly id: string
  /**
   * A JSON-encoded string containing the rest of the payload: `device_keys`,
   * `one_time_keys`, `fallback_keys`.
   *
   * It represents the body of the HTTP request.
   */
  readonly body: string
  /** Get its request type. */
  get type(): RequestType
}
/**
 * Data for a request to the `/keys/query` API endpoint
 * ([specification]).
 *
 * Returns the current devices and identity keys for the given users.
 *
 * [specification]: https://spec.matrix.org/unstable/client-server-api/#post_matrixclientv3keysquery
 */
export class KeysQueryRequest {
  /** The request ID. */
  readonly id: string
  /**
   * A JSON-encoded object of form:
   *
   * ```json
   * {"timeout": …, "device_keys": …}
   * ```
   */
  readonly body: string
  /** Get its request type. */
  get type(): RequestType
}
/**
 * Data for a request to the `/keys/claim` API endpoint
 * ([specification]).
 *
 * Claims one-time keys that can be used to establish 1-to-1 E2EE
 * sessions.
 *
 * [specification]: https://spec.matrix.org/unstable/client-server-api/#post_matrixclientv3keysclaim
 */
export class KeysClaimRequest {
  /** The request ID. */
  readonly id: string
  /**
   * A JSON-encoded object of form:
   *
   * ```json
   * {"timeout": …,  "one_time_keys": …}
   * ```
   */
  readonly body: string
  /** Get its request type. */
  get type(): RequestType
}
/**
 * Data for a request to the `/sendToDevice` API endpoint
 * ([specification]).
 *
 * Send an event to a single device or to a group of devices.
 *
 * [specification]: https://spec.matrix.org/unstable/client-server-api/#put_matrixclientv3sendtodeviceeventtypetxnid
 */
export class ToDeviceRequest {
  /** The request ID. */
  readonly id: string
  /** A string representing the type of event being sent to each devices. */
  readonly eventType: string
  /**
   * A string representing a request identifier unique to the access token
   * used to send the request.
   */
  readonly txnId: string
  /**
   * A JSON-encoded string containing the rest of the payload: `messages`.
   *
   * It represents the body of the HTTP request.
   */
  readonly body: string
  /** Get its request type. */
  get type(): RequestType
}
/**
 * Data for a request to the `/keys/signatures/upload` API endpoint
 * ([specification]).
 *
 * Publishes cross-signing signatures for the user.
 *
 * [specification]: https://spec.matrix.org/unstable/client-server-api/#post_matrixclientv3keyssignaturesupload
 */
export class SignatureUploadRequest {
  /** The request ID. */
  readonly id: string
  /**
   * A JSON-encoded string containing the rest of the payload: `signed_keys`.
   *
   * It represents the body of the HTTP request.
   */
  readonly body: string
  /** Get its request type. */
  get type(): RequestType
}
/**
 * A customized owned request type for sending out room messages
 * ([specification]).
 *
 * [specification]: https://spec.matrix.org/unstable/client-server-api/#put_matrixclientv3roomsroomidsendeventtypetxnid
 */
export class RoomMessageRequest {
  /** The request ID. */
  readonly id: string
  /** A string representing the room to send the event to. */
  readonly roomId: string
  /**
   * A string representing the transaction ID for this event.
   *
   * Clients should generate an ID unique across requests with the same
   * access token; it will be used by the server to ensure idempotency of
   * requests.
   */
  readonly txnId: string
  /** A string representing the type of event to be sent. */
  readonly eventType: string
  /** A JSON-encoded string containing the message's content. */
  readonly body: string
  /** Get its request type. */
  get type(): RequestType
}
/**
 * A request that will back up a batch of room keys to the server
 * ([specification]).
 *
 * [specification]: https://spec.matrix.org/unstable/client-server-api/#put_matrixclientv3room_keyskeys
 */
export class KeysBackupRequest {
  /** The request ID. */
  readonly id: string
  /**
   * A JSON-encoded string containing the rest of the payload: `rooms`.
   *
   * It represents the body of the HTTP request.
   */
  readonly body: string
  /** Get its request type. */
  get type(): RequestType
}
/** A decrypted room event. */
export class DecryptedRoomEvent {
  /** The JSON-encoded decrypted event. */
  readonly event: string
  /**
   * The user ID of the event sender, note this is untrusted data
   * unless the `verification_state` is as well trusted.
   */
  get sender(): UserId | null
  /**
   * The device ID of the device that sent us the event, note this
   * is untrusted data unless `verification_state` is as well
   * trusted.
   */
  get senderDevice(): DeviceId | null
  /**
   * The Curve25519 key of the device that created the megolm
   * decryption key originally.
   */
  get senderCurve25519Key(): string | null
  /**
   * The signing Ed25519 key that have created the megolm key that
   * was used to decrypt this session.
   */
  get senderClaimedEd25519Key(): string | null
  /**
   * Chain of Curve25519 keys through which this session was
   * forwarded, via `m.forwarded_room_key` events.
   */
  get forwardingCurve25519KeyChain(): Array<string>
  /**
   * The verification state of the device that sent us the event,
   * note this is the state of the device at the time of
   * decryption. It may change in the future if a device gets
   * verified or deleted.
   */
  shieldState(strict: boolean): ShieldState | null
}
/** Information on E2E device updates. */
export class DeviceLists {
  /** Create an empty `DeviceLists`. */
  constructor(changed?: Array<UserId> | undefined | null, left?: Array<UserId> | undefined | null)
  /** Returns true if there are no device list updates. */
  isEmpty(): boolean
  /**
   * List of users who have updated their device identity keys or
   * who now share an encrypted room with the client since the
   * previous sync.
   */
  get changed(): Array<UserId>
  /**
   * List of users who no longer share encrypted rooms since the
   * previous sync response.
   */
  get left(): Array<UserId>
}
export class Signatures {
  /** Creates a new, empty, signatures collection. */
  constructor()
  /**
   * Add the given signature from the given signer and the given key ID to
   * the collection.
   */
  addSignature(signer: UserId, keyId: DeviceKeyId, signature: Ed25519Signature): MaybeSignature | null
  /**
   * Try to find an Ed25519 signature from the given signer with
   * the given key ID.
   */
  getSignature(signer: UserId, keyId: DeviceKeyId): Ed25519Signature | null
  /** Get the map of signatures that belong to the given user. */
  get(signer: UserId): Record<string, MaybeSignature> | null
  /** Remove all the signatures we currently hold. */
  clear(): void
  /**
   * Do we hold any signatures or is our collection completely
   * empty.
   */
  get isEmpty(): boolean
  /** How many signatures do we currently hold. */
  get count(): bigint
  /** Get the json with all signatures */
  asJSON(): string
}
/**
 * Represents a potentially decoded signature (but not a validated
 * one).
 */
export class Signature {
  /** Get the Ed25519 signature, if this is one. */
  get ed25519(): Ed25519Signature | null
  /** Convert the signature to a base64 encoded string. */
  toBase64(): string
}
/**
 * Represents a signature that is either valid _or_ that could not be
 * decoded.
 */
export class MaybeSignature {
  /** Check whether the signature has been successfully decoded. */
  get isValid(): boolean
  /** Check whether the signature could not be successfully decoded. */
  get isInvalid(): boolean
  /** The signature, if successfully decoded. */
  get signature(): Signature | null
  /**
   * The base64 encoded string that is claimed to contain a
   * signature but could not be decoded, if any.
   */
  get invalidSignatureSource(): string | null
}
/** The result of a signature verification of a signed JSON object. */
export class SignatureVerification {
  /**
   * Give the backup signature state from the current device.
   * See SignatureState for values
   */
  get deviceState(): SignatureState
  /**
   * Give the backup signature state from the current user identity.
   * See SignatureState for values
   */
  get userState(): SignatureState
  /**
   * Is the result considered to be trusted?
   *
   * This tells us if the result has a valid signature from any of the
   * following:
   *
   * * Our own device
   * * Our own user identity, provided the identity is trusted as well
   * * Any of our own devices, provided the device is trusted as well
   */
  trusted(): boolean
}
/** An Ed25519 public key, used to verify digital signatures. */
export class Ed25519PublicKey {
  /** The number of bytes an Ed25519 public key has. */
  get length(): number
  /**
   * Serialize an Ed25519 public key to an unpadded base64
   * representation.
   */
  toBase64(): string
}
/**
 * An Ed25519 digital signature, can be used to verify the
 * authenticity of a message.
 */
export class Ed25519Signature {
  /**
   * Try to create an Ed25519 signature from an unpadded base64
   * representation.
   */
  constructor(signature: string)
  /**
   * Serialize a Ed25519 signature to an unpadded base64
   * representation.
   */
  toBase64(): string
}
/** A Curve25519 public key. */
export class Curve25519PublicKey {
  /** The number of bytes a Curve25519 public key has. */
  get length(): number
  /**
   * Serialize an Curve25519 public key to an unpadded base64
   * representation.
   */
  toBase64(): string
}
/** Struct holding the two public identity keys of an account. */
export class IdentityKeys {
  /** The Ed25519 public key, used for signing. */
  get ed25519(): Ed25519PublicKey
  /** The Curve25519 public key, used for establish shared secrets. */
  get curve25519(): Curve25519PublicKey
}
/** Object containing the versions of the Rust libraries we are using. */
export class Versions {
  /** The version of the vodozemac crate. */
  vodozemac: string
  /** The version of the matrix-sdk-crypto crate. */
  matrixSdkCrypto: string
}
