import { Runtime } from './parsebox/index.mjs';
import * as Types from '../type/index.mjs';
export declare const Module: Runtime.Module<{
    ExportModifier: Runtime.IUnion<boolean>;
    HeritageList: Runtime.IUnion<Types.TSchema[]>;
    Heritage: Runtime.IUnion<unknown[]>;
    InterfaceDeclaration: Runtime.ITuple<{
        [x: string]: Types.TIntersect<[...Types.TRef<string>[], Types.TObject<Types.TProperties>]>;
    }>;
    TypeAliasDeclaration: Runtime.ITuple<{
        [x: string]: Types.TSchema;
    }>;
    ModuleType: Runtime.IUnion<unknown>;
    ModuleProperties: Runtime.IUnion<Types.TProperties>;
    ModuleDeclaration: Runtime.ITuple<Types.TModule<Types.TProperties, {
        [x: string]: Types.TSchema;
        [x: number]: Types.TSchema;
    }>>;
    Literal: Runtime.IUnion<Types.TLiteral<string> | Types.TLiteral<number> | Types.TLiteral<boolean>>;
    Keyword: Runtime.IUnion<Types.TAny | Types.TNever | Types.TString | Types.TBoolean | Types.TNumber | Types.TInteger | Types.TBigInt | Types.TNull | Types.TSymbol | Types.TUndefined | Types.TUnknown | Types.TVoid>;
    KeyOf: Runtime.IUnion<boolean>;
    IndexArray: Runtime.IUnion<unknown[]>;
    Extends: Runtime.IUnion<unknown[]>;
    Base: Runtime.IUnion<unknown>;
    Factor: Runtime.ITuple<Types.TSchema>;
    ExprTermTail: Runtime.IUnion<[] | ["&", unknown, unknown]>;
    ExprTerm: Runtime.ITuple<Types.TSchema>;
    ExprTail: Runtime.IUnion<[] | ["|", unknown, unknown]>;
    Expr: Runtime.ITuple<Types.TSchema>;
    Type: Runtime.IRef<unknown>;
    PropertyKey: Runtime.IUnion<string>;
    Readonly: Runtime.IUnion<boolean>;
    Optional: Runtime.IUnion<boolean>;
    Property: Runtime.ITuple<{
        [x: string]: Types.TSchema;
    }>;
    PropertyDelimiter: Runtime.IUnion<[","] | [",", "\n"] | [";"] | [";", "\n"] | ["\n"]>;
    Properties: Runtime.IUnion<Types.TProperties>;
    Object: Runtime.ITuple<Types.TObject<Types.TProperties>>;
    Elements: Runtime.IUnion<unknown[]>;
    Tuple: Runtime.ITuple<Types.TTuple<Types.TSchema[]>>;
    Parameter: Runtime.ITuple<Types.TSchema>;
    Function: Runtime.ITuple<Types.TFunction<Types.TSchema[], Types.TSchema>>;
    Parameters: Runtime.IUnion<unknown[]>;
    Constructor: Runtime.ITuple<Types.TConstructor<Types.TSchema[], Types.TSchema>>;
    Mapped: Runtime.ITuple<Types.TLiteral<"Mapped types not supported">>;
    AsyncIterator: Runtime.ITuple<Types.TAsyncIterator<Types.TSchema>>;
    Iterator: Runtime.ITuple<Types.TIterator<Types.TSchema>>;
    Awaited: Runtime.ITuple<Types.TSchema>;
    Array: Runtime.ITuple<Types.TArray<Types.TSchema>>;
    Record: Runtime.ITuple<Types.TNever>;
    Promise: Runtime.ITuple<Types.TPromise<Types.TSchema>>;
    ConstructorParameters: Runtime.ITuple<Types.TTuple<Types.TSchema[]>>;
    FunctionParameters: Runtime.ITuple<Types.TTuple<Types.TSchema[]>>;
    InstanceType: Runtime.ITuple<Types.TSchema>;
    ReturnType: Runtime.ITuple<Types.TSchema>;
    Partial: Runtime.ITuple<Types.TObject<{}>>;
    Required: Runtime.ITuple<Types.TObject<{}>>;
    Pick: Runtime.ITuple<Types.TObject<{}>>;
    Omit: Runtime.ITuple<Types.TObject<{}>>;
    Exclude: Runtime.ITuple<Types.TNever>;
    Extract: Runtime.ITuple<Types.TSchema>;
    Uppercase: Runtime.ITuple<Types.TSchema>;
    Lowercase: Runtime.ITuple<Types.TSchema>;
    Capitalize: Runtime.ITuple<Types.TSchema>;
    Uncapitalize: Runtime.ITuple<Types.TSchema>;
    Date: Runtime.IConst<Types.TDate>;
    Uint8Array: Runtime.IConst<Types.TUint8Array>;
    Reference: Runtime.IIdent<Types.TSchema>;
    Main: Runtime.IUnion<unknown>;
}>;
