import { CommandDescription } from "./CommandDescription";
import { CommandMeta } from "./CommandMeta";
import { CommandTable } from "./CommandTable";
import { ParsedKeywords } from "./ParsedKeywords";
import { PresentationArgumentStream } from "./PresentationStream";
type CommandBase<TCommandMeta extends CommandMeta = CommandMeta> = {
    readonly description: CommandDescription<TCommandMeta>;
    readonly designator: string[];
    readonly commandTable: CommandTable;
};
export type Command<TCommandMeta extends CommandMeta = CommandMeta> = CompleteCommand<TCommandMeta> | PartialCommand<TCommandMeta>;
export type CompleteCommand<TCommandMeta extends CommandMeta = CommandMeta> = CommandBase<TCommandMeta> & {
    readonly isPartial: false;
    readonly immediateArguments: TCommandMeta["TImmediateArgumentsObjectTypes"];
    readonly rest?: TCommandMeta["TRestArgumentObjectType"][];
    readonly keywords: ParsedKeywords;
    toPartialCommand(): PartialCommand;
};
export type PartialCommand<TCommandMeta extends CommandMeta = CommandMeta> = CommandBase<TCommandMeta> & {
    readonly isPartial: true;
    readonly stream: PresentationArgumentStream;
};
export declare function isPartialCommand(command: Command): command is PartialCommand;
export declare function isCompleteCommand<TCommandMeta extends CommandMeta = CommandMeta>(command: Command<TCommandMeta>): command is CompleteCommand<TCommandMeta>;
export declare function makePartialCommand<TCommandMeta extends CommandMeta = CommandMeta>(stream: PresentationArgumentStream, commandDescription: CommandDescription<TCommandMeta>, commandTable: CommandTable, designator: string[]): PartialCommand<TCommandMeta>;
export {};
//# sourceMappingURL=Command.d.ts.map