/**
 * This exists because typescript is bad and if you
 * have the wrap function on in a type assertion, then
 * it will complain because the argument is not assignable to unknown.
 * As obviously the argument in the wrapper function is specific.
 */
export interface PresentationTypeWithoutWrap<ObjectType = unknown> {
    name: string;
    /**
     * Used when creating a presentation to ensure value is ObjectType.
     * This should not be used to determine the type of a given presentation,
     * that's what the `type` field on the presentation is for.
     */
    validator: (value: unknown) => value is ObjectType;
}
export type PresentationType<ObjectType = unknown> = PresentationTypeWithoutWrap<ObjectType> & {
    wrap: (object: ObjectType) => Presentation<ObjectType>;
};
export type ObjectTypeFromPresentationType<T> = T extends PresentationTypeWithoutWrap<infer ObjectType> ? ObjectType : never;
export interface Presentation<ObjectType = unknown> {
    object: ObjectType;
    presentationType: PresentationTypeWithoutWrap<ObjectType>;
}
export declare function findPresentationType<ObjectType = unknown>(name: string): PresentationType<ObjectType>;
export declare function registerPresentationType<ObjectType>(name: string, presentationType: PresentationType<ObjectType>): PresentationType<ObjectType>;
export declare function definePresentationType<ObjectType>(description: PresentationType<ObjectType>): PresentationType<ObjectType>;
//# sourceMappingURL=Presentation.d.ts.map