"use strict";
// Copyright 2022 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.findPresentationType = findPresentationType;
exports.registerPresentationType = registerPresentationType;
exports.definePresentationType = definePresentationType;
const PRESENTATION_TYPES = new Map();
function findPresentationType(name) {
    const entry = PRESENTATION_TYPES.get(name);
    if (entry) {
        return entry;
    }
    else {
        throw new TypeError(`presentation type with the name: ${name} was not registered`);
    }
}
function registerPresentationType(name, presentationType) {
    if (PRESENTATION_TYPES.has(name)) {
        throw new TypeError(`presentation type with the name: ${name} has already been registered`);
    }
    PRESENTATION_TYPES.set(name, presentationType);
    return presentationType;
}
function definePresentationType(description) {
    return registerPresentationType(description.name, Object.freeze(description));
}
//# sourceMappingURL=Presentation.js.map