import { Result } from "@gnuxie/typescript-result";
import { ParameterDescription, Prompt } from "./ParameterDescription";
import { Presentation, PresentationTypeWithoutWrap } from "./Presentation";
import { KeywordParser } from "./KeywordParameterDescription";
import { PartialCommand } from "./Command";
import { PresentationSchema } from "./PresentationSchema";
/**
 * Describes a rest parameter for a command.
 * This consumes any arguments left over in the call to a command
 * into an array and ensures that each can be accepted by the `acceptor`.
 *
 * Any keywords in the rest of the command will be given to the `keywordParser`.
 */
export interface RestDescription<ObjectType = unknown> extends ParameterDescription<ObjectType> {
    readonly name: string;
    /** The presentation type of each item. */
    readonly acceptor: PresentationSchema<ObjectType>;
    parseRest(partialCommand: PartialCommand, keywordParser: KeywordParser): Result<Presentation<ObjectType>[]>;
    readonly description?: string | undefined;
}
/**
 * Describes a rest parameter for a command.
 * This consumes any arguments left over in the call to a command
 * into an array and ensures that each can be accepted by the `acceptor`.
 *
 * Any keywords in the rest of the command will be given to the `keywordParser`.
 */
export declare class StandardRestDescription<ObjectType = unknown> implements RestDescription<ObjectType> {
    readonly name: string;
    readonly prompt?: Prompt<ObjectType> | undefined;
    readonly description?: string | undefined;
    readonly acceptor: PresentationSchema<ObjectType>;
    constructor(name: string, 
    /** The presentation type of each item. */
    acceptor: PresentationTypeWithoutWrap<ObjectType> | PresentationSchema<ObjectType>, prompt?: Prompt<ObjectType> | undefined, description?: string | undefined);
    /**
     * Parse the rest of a command.
     * @param stream An argument stream that starts at the rest of a command.
     * @param keywordParser Used to store any keywords found in the rest of the command.
     * @returns A ActionResult of ReadItems associated with the rest of the command.
     * If a ReadItem or Keyword is invalid for the command, then an error will be returned.
     */
    parseRest(partialCommand: PartialCommand, keywordParser: KeywordParser): Result<Presentation<ObjectType>[]>;
}
export type DescribeRestParameters<ObjectType = unknown> = Omit<RestDescription<ObjectType>, "parseRest" | "acceptor"> & {
    acceptor: PresentationTypeWithoutWrap<ObjectType> | PresentationSchema<ObjectType>;
};
export declare function describeRestParameters<ObjectType = unknown>(options: DescribeRestParameters<ObjectType>): RestDescription<ObjectType>;
//# sourceMappingURL=RestParameterDescription.d.ts.map