import { Result, ResultError } from "@gnuxie/typescript-result";
import { Command, CommandDescription, CompleteCommand, ExtractCommandMeta, ParameterDescription, PartialCommand, Presentation } from "../Command";
import { MatrixRendererDescription } from "./MatrixRendererDescription";
import { DocumentNode } from "../DeadDocument";
import { AdaptorContextToCommandContextTranslator } from "../Adaptor/AdaptorContextToCommandContextTranslator";
import { StringUserID } from "@the-draupnir-project/matrix-basic-types";
import { CommandMeta } from "../Command/CommandMeta";
import { CommandInvokerCallbacks } from "../Adaptor";
export type BasicInvocationInformation = {
    readonly commandSender: StringUserID;
};
export type InvocationInformationFromEventContext<MatrixEventContext, InvocationInformation extends BasicInvocationInformation = BasicInvocationInformation> = (eventContext: MatrixEventContext) => InvocationInformation;
export interface MatrixInterfaceAdaptor<AdaptorContext, MatrixEventContext> {
    /**
     * Invoke the command object, running the command executor and then calling
     * each of the configured renderers for the interface adaptor.
     */
    invoke(command: CompleteCommand, adaptorContext: AdaptorContext, eventContext: MatrixEventContext): Promise<Result<void>>;
    /**
     * Parse the arguments to the command description and then call `invoke`.
     * The commandDesignator is required so that we can produce a `Command` object.
     */
    parseAndInvoke(partialCommand: PartialCommand, adaptorContext: AdaptorContext, eventContext: MatrixEventContext): Promise<Result<void>>;
    registerRendererDescription<TCommandDescription extends CommandDescription>(commandDescription: TCommandDescription, rendererDescription: MatrixRendererDescription): MatrixInterfaceAdaptor<AdaptorContext, MatrixEventContext>;
    describeRenderer<TCommandMeta extends CommandMeta>(commandDescription: CommandDescription<TCommandMeta>, rendererDescription: DescribeMatrixRenderer<AdaptorContext, MatrixEventContext, TCommandMeta["CommandResult"]>): MatrixInterfaceAdaptor<AdaptorContext, MatrixEventContext>;
    isDescribingRendererForCommand<TCommandDescription extends CommandDescription>(commandDescription: TCommandDescription): boolean;
    renderedCommands(): CommandDescription[];
}
export type MatrixInterfaceDefaultRenderer<AdaptorContext, MatrixEventContext, CommandResult = unknown> = (adaptorCotnext: AdaptorContext, matrixEventContext: MatrixEventContext, command: Command, commandResult: Result<CommandResult>) => Promise<Result<void>>;
export type MatrixInterfaceEventsFromDeadDocument<AdaptorContext, MatrixEventContext> = (adaptorContext: AdaptorContext, eventContext: MatrixEventContext, document: DocumentNode) => Promise<Result<void>>;
export type MatrixInterfaceRendererFailedCB<AdaptorContext, MatrixEventContext> = (adaptorContext: AdaptorContext, matrixEventContext: MatrixEventContext, command: Command, error: ResultError) => void;
export type MatrixInterfaceAdaptorCallbacks<AdaptorContext, MatrixEventContext> = {
    readonly promptDefault: <ObjectType = unknown>(adaptorContext: AdaptorContext, eventContext: MatrixEventContext, parameter: ParameterDescription<ObjectType>, command: PartialCommand, defaultPrompt: Presentation<ObjectType>, existingArguments: Presentation[]) => Promise<Result<void>>;
    readonly promptSuggestions: <ObjectType>(adaptorContext: AdaptorContext, eventContext: MatrixEventContext, parameter: ParameterDescription<ObjectType>, command: PartialCommand, suggestions: Presentation<ObjectType>[], existingArguments: Presentation[]) => Promise<Result<void>>;
    /** Render the result and return an error if there was a problem while rendering. */
    readonly defaultRenderer: MatrixInterfaceDefaultRenderer<AdaptorContext, MatrixEventContext>;
    readonly matrixEventsFromDeadDocument: MatrixInterfaceEventsFromDeadDocument<AdaptorContext, MatrixEventContext>;
    readonly rendererFailedCB: MatrixInterfaceRendererFailedCB<AdaptorContext, MatrixEventContext>;
    /**
     * Render a confirmation prompt to matrix.
     */
    readonly matrixEventsFromConfirmationPrompt: (adaptor: AdaptorContext, event: MatrixEventContext, command: CompleteCommand, document: DocumentNode) => Promise<Result<void>>;
};
export declare class StandardMatrixInterfaceAdaptor<AdaptorContext, MatrixEventContext> implements MatrixInterfaceAdaptor<AdaptorContext, MatrixEventContext> {
    private readonly adaptorToCommandContextTranslator;
    private readonly invocationInformationFromEventContext;
    private readonly commandInvoker;
    private readonly renderers;
    private readonly callbacks;
    constructor(adaptorToCommandContextTranslator: AdaptorContextToCommandContextTranslator<AdaptorContext>, invocationInformationFromEventContext: InvocationInformationFromEventContext<MatrixEventContext>, interfaceAdaptorCallbacks: MatrixInterfaceAdaptorCallbacks<AdaptorContext, MatrixEventContext>, commandInvokerCallbacks: CommandInvokerCallbacks<BasicInvocationInformation>);
    invoke<CommandResult>(command: CompleteCommand, adaptorContext: AdaptorContext, matrixEventContext: MatrixEventContext): Promise<Result<CommandResult>>;
    private findRendererForCommandDescription;
    private runRenderersOnCommandResult;
    private maybeRunDefaultRenderer;
    private maybeRunJSXRenderer;
    private maybeRunArbritraryRenderer;
    registerRendererDescription(commandDescription: CommandDescription, rendererDescription: MatrixRendererDescription): this;
    describeRenderer<TCommandDescription extends CommandDescription>(commandDescription: TCommandDescription, rendererDescription: DescribeMatrixRenderer<AdaptorContext, MatrixEventContext, ExtractCommandMeta<TCommandDescription>["CommandResult"]>): MatrixInterfaceAdaptor<AdaptorContext, MatrixEventContext>;
    parseAndInvoke(partialCommand: PartialCommand, adaptorContext: AdaptorContext, eventContext: MatrixEventContext): Promise<Result<void>>;
    isDescribingRendererForCommand<TCommandDescription extends CommandDescription>(commandDescription: TCommandDescription): boolean;
    renderedCommands(): CommandDescription[];
}
export type DescribeMatrixRenderer<AdaptorContext = unknown, MatrixEventContext = unknown, CommandResult = unknown, AdaptorArguments extends unknown[] = unknown[]> = Omit<MatrixRendererDescription<AdaptorContext, MatrixEventContext, CommandResult, AdaptorArguments>, "isAlwaysSupposedToUseDefaultRenderer"> & {
    isAlwaysSupposedToUseDefaultRenderer?: boolean;
};
//# sourceMappingURL=MatrixInterfaceAdaptor.d.ts.map