import { MatrixEventReference, MatrixRoomAlias, MatrixRoomID, MatrixUserID } from "@the-draupnir-project/matrix-basic-types";
import { Presentation } from "../Command/Presentation";
import { Keyword } from "../Command/Keyword";
/**
 * If you are wondering why commands specify on presentation type and not
 * their actual type, then imagine that you have a a presentation type
 * for a person's name, and you render that in handwriting.
 * The person's name is really just a string, and it'd be wrong to be able to
 * get any string with that command as a name. OTOH, I don't really see the
 * point in that? WHy not just make a real type for a person's name?
 */
export declare const StringPresentationType: import("../Command/Presentation").PresentationType<string>;
export declare const NumberPresentationType: import("../Command/Presentation").PresentationType<number>;
export declare const BooleanPresentationType: import("../Command/Presentation").PresentationType<boolean>;
export declare const KeywordPresentationType: import("../Command/Presentation").PresentationType<Keyword>;
export declare const MatrixRoomIDPresentationType: import("../Command/Presentation").PresentationType<MatrixRoomID>;
export declare const MatrixRoomAliasPresentationType: import("../Command/Presentation").PresentationType<MatrixRoomAlias>;
export declare const MatrixRoomReferencePresentationSchema: import("../Command/PresentationSchema").UnionPresentationSchema<MatrixRoomID | MatrixRoomAlias>;
export declare const MatrixUserIDPresentationType: import("../Command/Presentation").PresentationType<MatrixUserID>;
export declare const MatrixEventReferencePresentationType: import("../Command/Presentation").PresentationType<MatrixEventReference>;
export declare function makeMatrixEventReferencePresentation(value: MatrixEventReference): Presentation<MatrixEventReference>;
//# sourceMappingURL=TextPresentationTypes.d.ts.map