"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-basic-types
// https://github.com/the-draupnir-project/matrix-basic-types
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringServerNameRegex = exports.StringServerNameRegexPart = void 0;
exports.isStringServerName = isStringServerName;
exports.StringServerName = StringServerName;
/**
 * Do NOT use this regex to verify incoming events because servers are fucking shit
 * and cannot validate anything when it counts.
 */
exports.StringServerNameRegexPart = /(?:(?:\d{1,3}\.){3}\d{1,3}|\[[0-9A-Fa-f:.]{2,45}\]|[A-Za-z0-9.-]{1,255})(?::\d{1,5})?/;
exports.StringServerNameRegex = new RegExp(`^${exports.StringServerNameRegexPart.source}$`);
function isStringServerName(string) {
    return exports.StringServerNameRegex.test(string);
}
function StringServerName(string) {
    if (typeof string === "string" && isStringServerName(string)) {
        return string;
    }
    throw new TypeError("Not a valid StringServerName");
}
//# sourceMappingURL=StringServerName.js.map