import { StringServerName } from "./StringServerName";
/**
 * Do not use this, Synapse does not validate user ids and it isn't an auth check....
 */
export declare const HistoricalStringUserIDLocalpartRegex: RegExp;
export declare const StringUserIDRegex: RegExp;
export type StringUserIDBrand = {
    readonly StringUserID: unique symbol;
};
export type StringUserID = string & StringUserIDBrand;
export declare function isStringUserID(string: string): string is StringUserID;
export declare function StringUserID<T>(string: unknown): T extends StringUserID ? StringUserID : never;
export declare function userServerName(userID: StringUserID): StringServerName;
export declare function userLocalpart(userID: StringUserID): string;
//# sourceMappingURL=StringUserID.d.ts.map