"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
const _1 = require("./");
test("isStringUserID", function () {
    expect((0, _1.isStringUserID)("@foo:localhost:9999")).toBe(true);
    expect((0, _1.isStringUserID)("@foo@mastodon.social")).toBe(false);
    expect((0, _1.isStringUserID)("@ synapse is really bad :example.com")).toBe(true);
});
test("StringUserID serverName", function () {
    expect((0, _1.userServerName)((0, _1.StringUserID)("@foo:localhost:9999"))).toBe("localhost:9999");
});
test("StringUserID localpart", function () {
    expect((0, _1.userLocalpart)((0, _1.StringUserID)("@foo:localhost:9999"))).toBe("foo");
});
test("StringRoomID", function () {
    expect((0, _1.isStringRoomID)("!foo:localhost:9999")).toBe(true);
    expect((0, _1.isStringRoomID)("@foo:localhost:9999")).toBe(false);
});
test("StringRoomAlias", function () {
    expect((0, _1.isStringRoomAlias)("#foo:example.com")).toBe(true);
    expect((0, _1.isStringRoomAlias)("!foo:example.com")).toBe(false);
});
test("StringRoomAlias roomAliasLocalpart", function () {
    expect((0, _1.roomAliasLocalpart)((0, _1.StringRoomAlias)("#foo:example.com"))).toBe("foo");
});
test("StringroomAlias serverName", function () {
    expect((0, _1.roomAliasServerName)((0, _1.StringRoomAlias)("#foo:localhost:9999"))).toBe("localhost:9999");
});
test("StringServerName", function () {
    expect((0, _1.isStringServerName)("example.com")).toBe(true);
});
// test accessing server names!!!!
//# sourceMappingURL=StringlyTypedMatrix.test.js.map