"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomStateRefresh = void 0;
const await_lock_1 = __importDefault(require("await-lock"));
const matrix_protection_suite_1 = require("matrix-protection-suite");
const log = new matrix_protection_suite_1.Logger('RoomStateRefresh');
/**
 * Basically we want to be able to control the rate at which we refresh room
 * state because it can overwhelm servers if we request all the room state
 * at once. Currently we just use a simple lock to make sure that it happens
 * sequentially.
 */
class RoomStateRefresh {
    constructor() {
        this.sequentialLock = new await_lock_1.default();
    }
    async refreshStateAsync(issuer) {
        await this.sequentialLock.acquireAsync();
        try {
            log.debug(`Refreshing room state for the room: ${issuer.room.toPermalink()}`);
            await issuer.refreshRoomState();
        }
        finally {
            this.sequentialLock.release();
        }
    }
    refreshState(issuer) {
        void this.refreshStateAsync(issuer);
    }
}
exports.RoomStateRefresh = RoomStateRefresh;
//# sourceMappingURL=RoomStateRefresh.js.map