/**
 * Copyright (C) 2024 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
import { ILoggerProvider } from 'matrix-protection-suite';
/**
 * A logger provider that uses the `LogService` from the bot-sdk to provide logging capability.
 * @see {@link setGlobalLoggerProvider}
 */
export declare class BotSDKLogServiceLogger implements ILoggerProvider {
    debug(moduleName: string, message: string, ...parts: unknown[]): void;
    info(moduleName: string, message: string, ...parts: unknown[]): void;
    warn(moduleName: string, message: string, ...parts: unknown[]): void;
    error(moduleName: string, message: string, ...parts: unknown[]): void;
}
//# sourceMappingURL=BotSDKLogging.d.ts.map