"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.BlockStatusResponse = void 0;
const typebox_1 = require("@sinclair/typebox");
const matrix_protection_suite_1 = require("matrix-protection-suite");
exports.BlockStatusResponse = typebox_1.Type.Object({
    block: typebox_1.Type.Boolean({
        description: 'True if the room is blocked, otherwise false.',
    }),
    user_id: typebox_1.Type.Optional(typebox_1.Type.Union([matrix_protection_suite_1.StringUserIDSchema], {
        description: "User ID of the person who added the room to the blocking list. Only present if 'block' is true.",
    })),
});
//# sourceMappingURL=BlockStatusEndpoint.js.map