"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRedactionStatusResponse = exports.UserRedactionResponse = void 0;
const typebox_1 = require("@sinclair/typebox");
exports.UserRedactionResponse = typebox_1.Type.Object({
    redact_id: typebox_1.Type.String({ description: 'An opaque ID for the redaction.' }),
});
exports.UserRedactionStatusResponse = typebox_1.Type.Object({
    status: typebox_1.Type.Union([
        typebox_1.Type.Literal('scheduled'),
        typebox_1.Type.Literal('active'),
        typebox_1.Type.Literal('complete'),
        typebox_1.Type.Literal('failed'),
    ], { description: 'Status of the redaction job.' }),
    failed_redactions: typebox_1.Type.Record(typebox_1.Type.String({ description: 'Event ID that failed redaction.' }), typebox_1.Type.String({
        description: 'Error message explaining why redaction failed.',
    })),
});
//# sourceMappingURL=UserRedactionEndpoint.js.map