"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DummyRoomJoiner = void 0;
exports.resolveRoomFake = resolveRoomFake;
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const Action_1 = require("../Interface/Action");
async function resolveRoomFake(roomID) {
    if (typeof roomID === 'string') {
        if (!(0, matrix_basic_types_1.isStringRoomID)(roomID)) {
            throw new TypeError(`Fake can't deal with aliases.`);
        }
        else {
            return (0, Action_1.Ok)(matrix_basic_types_1.MatrixRoomReference.fromRoomID(roomID));
        }
    }
    else if (roomID instanceof matrix_basic_types_1.MatrixRoomAlias) {
        throw new TypeError(`Fake can't deal with aliases.`);
    }
    else {
        return (0, Action_1.Ok)(roomID);
    }
}
exports.DummyRoomJoiner = Object.freeze({
    async joinRoom(room) {
        return await resolveRoomFake(room);
    },
    resolveRoom: resolveRoomFake,
});
//# sourceMappingURL=DummyClientPlatform.js.map