import { StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { PowerLevelsEventContent } from '../MatrixTypes/PowerLevels';
import { RoomCreateEvent } from '../MatrixTypes/CreateRoom';
export declare enum PowerLevelPermission {
    Ban = "ban",
    Invite = "invite",
    Kick = "kick",
    Redact = "redact"
}
export type MissingPermissionsChange = {
    missingStatePermissions: string[];
    missingPermissions: PowerLevelPermission[];
    missingEventPermissions: string[];
    isPrivilidgedInNextPowerLevels: boolean;
    isPrivilidgedInPriorPowerLevels: boolean;
};
export declare const PowerLevelsMirror: Readonly<{
    getUserPowerLevel(who: StringUserID, content?: PowerLevelsEventContent): number;
    getStatePowerLevel(eventType: string, content?: PowerLevelsEventContent): number;
    getEventPowerLevel(eventType: string, content?: PowerLevelsEventContent): number;
    isUserAbleToSendState(who: StringUserID, eventType: string, content?: PowerLevelsEventContent): boolean;
    isUserAbleToUse(who: StringUserID, permission: PowerLevelPermission, content?: PowerLevelsEventContent): boolean;
    isUserAbleToSendEvent(who: StringUserID, eventType: string, content?: PowerLevelsEventContent): boolean;
    missingPermissions(clientUserID: StringUserID, requiredPermissions: PowerLevelPermission[], powerLevelsContent?: PowerLevelsEventContent): PowerLevelPermission[];
    missingStatePermissions(clientUserID: StringUserID, requiredStatePermissions: string[], powerLevelsContent?: PowerLevelsEventContent): string[];
    missingEventPermissions(clientUserID: StringUserID, requiredEventPermissions: string[], powerLevelsContent?: PowerLevelsEventContent): string[];
    calculateMissingPermissionsInNewRoom(userID: StringUserID, options: {
        createEvent: RoomCreateEvent;
        nextPowerLevelsContent: PowerLevelsEventContent;
        requiredEventPermissions: string[];
        requiredPermissions: PowerLevelPermission[];
        requiredStatePermissions: string[];
    }): MissingPermissionsChange;
    calculateNewMissingPermissions(userID: StringUserID, { createEvent, nextPowerLevelsContent, previousPowerLevelsContent, requiredEventPermissions, requiredPermissions, requiredStatePermissions, isNewlyAddedRoom, }: {
        createEvent: RoomCreateEvent;
        nextPowerLevelsContent?: PowerLevelsEventContent;
        previousPowerLevelsContent?: PowerLevelsEventContent;
        requiredEventPermissions: string[];
        requiredPermissions: PowerLevelPermission[];
        requiredStatePermissions: string[];
        isNewlyAddedRoom?: boolean;
    }): MissingPermissionsChange;
}>;
//# sourceMappingURL=PowerLevelsMirror.d.ts.map