"use strict";
// Copyright (C) 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstantPeriodBatch = void 0;
class ConstantPeriodBatch {
    constructor(cb, delayMS = 0) {
        this.finished = false;
        this.timeoutID = setTimeout(() => {
            this.finished = true;
            cb();
        }, delayMS);
    }
    isFinished() {
        return this.finished;
    }
    cancel() {
        clearTimeout(this.timeoutID);
        this.finished = true;
    }
}
exports.ConstantPeriodBatch = ConstantPeriodBatch;
//# sourceMappingURL=ConstantPeriodBatch.js.map