"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakePersistentConfigBackend = exports.FakeMatrixAccountData = void 0;
const Action_1 = require("./Action");
class FakeMatrixAccountData {
    constructor(initialData) {
        this.fakePersistedData = initialData;
    }
    requestAccountData() {
        return Promise.resolve((0, Action_1.Ok)(this.fakePersistedData));
    }
    storeAccountData(data) {
        this.fakePersistedData = data;
        return Promise.resolve((0, Action_1.Ok)(undefined));
    }
}
exports.FakeMatrixAccountData = FakeMatrixAccountData;
class FakePersistentConfigBackend {
    constructor(initialData) {
        this.fakePersistedData = initialData;
    }
    saveEncodedConfig(data) {
        this.fakePersistedData = data;
        return Promise.resolve((0, Action_1.Ok)(undefined));
    }
    requestUnparsedConfig() {
        return Promise.resolve((0, Action_1.Ok)(this.fakePersistedData));
    }
}
exports.FakePersistentConfigBackend = FakePersistentConfigBackend;
//# sourceMappingURL=FakePersistentMatrixData.js.map