"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardLoggableConfigTracker = void 0;
class StandardLoggableConfigTracker {
    constructor() {
        this.loggables = new Set();
    }
    addLoggableConfig(config) {
        this.loggables.add(config);
    }
    removeLoggableConfig(config) {
        this.loggables.delete(config);
    }
    logCurrentConfig() {
        for (const loggable of this.loggables) {
            loggable.logCurrentConfig();
        }
    }
}
exports.StandardLoggableConfigTracker = StandardLoggableConfigTracker;
//# sourceMappingURL=LoggableConfig.js.map