import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { ActionError, ActionResult } from './Action';
import { ActionException, ActionExceptionKind } from './ActionException';
export interface RoomUpdateError extends ActionError {
    readonly room: MatrixRoomID;
}
export declare class RoomActionError extends ActionError implements RoomUpdateError {
    readonly room: MatrixRoomID;
    constructor(room: MatrixRoomID, message: string, elaborations?: string[]);
    static Result(message: string, { room }: {
        room: MatrixRoomID;
    }): ActionResult<never, PermissionError>;
    static fromActionError(room: MatrixRoomID, error: ActionError): RoomUpdateError;
}
export declare class PermissionError extends RoomActionError {
}
export declare class RoomUpdateException extends ActionException implements RoomUpdateError {
    readonly room: MatrixRoomID;
    constructor(room: MatrixRoomID, ...args: ConstructorParameters<typeof ActionException>);
    static Result<Ok>(message: string, options: {
        exception: Error;
        exceptionKind: ActionExceptionKind;
        room: MatrixRoomID;
    }): ActionResult<Ok, RoomUpdateException>;
    static fromActionException(room: MatrixRoomID, error: ActionException): RoomUpdateException;
}
//# sourceMappingURL=RoomUpdateError.d.ts.map