"use strict";
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-appservice-bridge
// https://github.com/matrix-org/matrix-appservice-bridge
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
exports.setGlobalLoggerProvider = setGlobalLoggerProvider;
/**
 * A logger provider that uses the `console` object to provide logging capability.
 * Intended only as a default that should be replaced by any client of this library.
 * @see {@link setGlobalLoggerProvider}
 */
class DumbConsoleLogger {
    debug(...parts) {
        console.debug(...parts);
    }
    info(...parts) {
        console.info(...parts);
    }
    warn(...parts) {
        console.warn(...parts);
    }
    error(...parts) {
        console.error(...parts);
    }
}
let globalLoggerProvider = new DumbConsoleLogger();
/**
 * This is a utility used throughout the library to provide generic logging
 * capability without being tied to one provider or logging implementation.
 * @see {@link setGlobalLoggerProvider}
 */
class Logger {
    constructor(moduleName) {
        this.moduleName = moduleName;
    }
    debug(message, ...parts) {
        globalLoggerProvider.debug(this.moduleName, message, ...parts);
    }
    info(message, ...parts) {
        globalLoggerProvider.info(this.moduleName, message, ...parts);
    }
    warn(message, ...parts) {
        globalLoggerProvider.warn(this.moduleName, message, ...parts);
    }
    error(message, ...parts) {
        globalLoggerProvider.error(this.moduleName, message, ...parts);
    }
}
exports.Logger = Logger;
/**
 * Allows the provider for all instances of `Logger` to be set.
 * @param provider An object that implements `ILoggerProvider`.
 * @see {@link ILoggerProvider}.
 */
function setGlobalLoggerProvider(provider) {
    globalLoggerProvider = provider;
}
//# sourceMappingURL=Logger.js.map