"use strict";
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardEventDecoder = void 0;
const typebox_1 = require("@sinclair/typebox");
const Action_1 = require("../Interface/Action");
const Value_1 = require("../Interface/Value");
const Events_1 = require("./Events");
const immutable_1 = require("immutable");
class StandardEventDecoder {
    constructor(decodersByType = (0, immutable_1.Map)(), invalidContentDecoder) {
        this.decodersByType = decodersByType;
        this.invalidContentDecoder = invalidContentDecoder;
        // nothing to do.
    }
    static blankEventDecoder() {
        return new StandardEventDecoder((0, immutable_1.Map)());
    }
    getDecoderForEventType(type) {
        return this.decodersByType.get(type);
    }
    setDecoderForEventType(type, decoder) {
        return new StandardEventDecoder(this.decodersByType.set(type, decoder), this.invalidContentDecoder);
    }
    decodeEvent(event) {
        if (event === null ||
            typeof event !== 'object' ||
            !('type' in event) ||
            typeof event['type'] !== 'string') {
            throw new TypeError(`Somehow there's malformed events being given by the homeserver.`);
        }
        const decoder = this.decodersByType.get(event.type);
        const decodeResult = decoder
            ? decoder(event)
            : Value_1.Value.Decode(UnknownEvent, event);
        if ((0, Action_1.isOk)(decodeResult)) {
            return decodeResult;
        }
        if (this.invalidContentDecoder === undefined) {
            return decodeResult;
        }
        return this.invalidContentDecoder(event);
    }
    decodeStateEvent(event) {
        const result = this.decodeEvent(event);
        if ((0, Action_1.isError)(result)) {
            return result;
        }
        else if ('state_key' in result.ok &&
            typeof result.ok.state_key === 'string') {
            return result;
        }
        throw new TypeError('Somehow decoded a state event without a state key');
    }
    setDecoderForInvalidEventContent(decoder) {
        return new StandardEventDecoder(this.decodersByType, decoder);
    }
    getDecoderForInvalidContent() {
        if (this.invalidContentDecoder === undefined) {
            throw new TypeError('No decoder for invalid content has been set on this event decoder.');
        }
        return this.invalidContentDecoder;
    }
}
exports.StandardEventDecoder = StandardEventDecoder;
const UnknownEvent = (0, Events_1.RoomEvent)(typebox_1.Type.Record(typebox_1.Type.String(), typebox_1.Type.Unknown()));
//# sourceMappingURL=EventDecoder.js.map