"use strict";
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermalinkSchema = exports.RoomReferencePermalinkSchema = exports.RoomAliasPermalinkSchema = exports.RoomIDPermalinkSchema = exports.EventPermalinkSchema = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const typebox_1 = require("@sinclair/typebox");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
function decodePermalink(link, permalinkDecoder) {
    const permalinkResult = permalinkDecoder(link);
    if ((0, typescript_result_1.isError)(permalinkResult)) {
        throw new TypeError(permalinkResult.error.message);
    }
    else {
        return permalinkResult.ok;
    }
}
// It is important to guard the schema with this pattern in case it is used in a
// union later on.
const EventPermalinkSchemaRegex = /^https:\/\/matrix\.to\/#\/[^/?]+\/(?:\$|%24)/;
exports.EventPermalinkSchema = typebox_1.Type.Transform(typebox_1.Type.String({ pattern: EventPermalinkSchemaRegex.source }))
    .Decode((value) => decodePermalink(value, matrix_basic_types_1.MatrixEventReference.fromPermalink))
    .Encode((value) => value.toPermalink());
const RoomIDPermalinkSchemaRegex = /^https:\/\/matrix\.to\/#\/![^/?]+(?:\?.*)?$/;
exports.RoomIDPermalinkSchema = typebox_1.Type.Transform(typebox_1.Type.String({ pattern: RoomIDPermalinkSchemaRegex.source }))
    .Decode((value) => {
    const roomReference = decodePermalink(value, matrix_basic_types_1.MatrixRoomReference.fromPermalink);
    if (roomReference instanceof matrix_basic_types_1.MatrixRoomAlias) {
        throw new TypeError('Things are badly wrong');
    }
    return roomReference;
})
    .Encode((value) => value.toPermalink());
const RoomAliasPermalinkSchemaRegex = /^https:\/\/matrix\.to\/#\/(?:#|%23)[^/?]+$/;
exports.RoomAliasPermalinkSchema = typebox_1.Type.Transform(typebox_1.Type.String({ pattern: RoomAliasPermalinkSchemaRegex.source }))
    .Decode((value) => {
    const roomReference = decodePermalink(value, matrix_basic_types_1.MatrixRoomReference.fromPermalink);
    if (roomReference instanceof matrix_basic_types_1.MatrixRoomID) {
        throw new TypeError('Things are badly wrong');
    }
    return roomReference;
})
    .Encode((value) => value.toPermalink());
exports.RoomReferencePermalinkSchema = typebox_1.Type.Union([
    exports.RoomIDPermalinkSchema,
    exports.RoomAliasPermalinkSchema,
]);
exports.PermalinkSchema = typebox_1.Type.Union([
    exports.RoomIDPermalinkSchema,
    exports.RoomAliasPermalinkSchema,
    exports.EventPermalinkSchema,
]);
//# sourceMappingURL=PermalinkSchema.js.map