import { EDStatic } from '../Interface/Static';
import { StringEventID } from '@the-draupnir-project/matrix-basic-types';
export type RedactionContent = EDStatic<typeof RedactionContent>;
export declare const RedactionContent: import("@sinclair/typebox").TObject<{
    redacts: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnsafe<StringEventID>>;
    reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
}>;
export type Redaction = EDStatic<typeof Redaction>;
export declare const Redaction: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TObject<{
        redacts: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnsafe<StringEventID>>;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    redacts: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnsafe<StringEventID>>;
    type: import("@sinclair/typebox").TLiteral<"m.room.redaction">;
}>]>;
export declare function redactionTargetEvent(event: Redaction): StringEventID | undefined;
//# sourceMappingURL=Redaction.d.ts.map