"use strict";
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomMessage = exports.AudioMessageContent = exports.VideoMessageContent = exports.ImageMessageContent = exports.ImageInfo = exports.ThumbnailInfo = exports.NoticeMessageContent = exports.TextMessageContent = exports.MessageContent = void 0;
const typebox_1 = require("@sinclair/typebox");
const Events_1 = require("./Events");
exports.MessageContent = typebox_1.Type.Object({
    body: typebox_1.Type.String({
        description: 'The textual representation of this message.',
    }),
    msgtype: typebox_1.Type.String({
        description: 'The type of message, e.g. `m.image`, `m.text`',
    }),
});
exports.TextMessageContent = typebox_1.Type.Object({
    body: typebox_1.Type.String({ description: 'The body of the message.' }),
    msgtype: typebox_1.Type.Literal('m.text'),
    format: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The format used in the `formatted_body`. Currently only\n`org.matrix.custom.html` is supported.',
    })),
    formatted_body: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The formatted version of the `body`. This is required if `format`\nis specified.',
    })),
});
exports.NoticeMessageContent = typebox_1.Type.Object({
    body: typebox_1.Type.String({ description: 'The notice text to send.' }),
    msgtype: typebox_1.Type.Literal('m.notice'),
    format: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The format used in the `formatted_body`. Currently only\n`org.matrix.custom.html` is supported.',
    })),
    formatted_body: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The formatted version of the `body`. This is required if `format`\nis specified.',
    })),
});
exports.ThumbnailInfo = typebox_1.Type.Object({
    h: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The intended display height of the image in pixels. This may\ndiffer from the intrinsic dimensions of the image file.',
    })),
    w: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The intended display width of the image in pixels. This may\ndiffer from the intrinsic dimensions of the image file.',
    })),
    mimetype: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The mimetype of the image, e.g. `image/jpeg`.',
    })),
    size: typebox_1.Type.Optional(typebox_1.Type.Number({ description: 'Size of the image in bytes.' })),
});
exports.ImageInfo = typebox_1.Type.Object({
    h: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The intended display height of the image in pixels. This may\ndiffer from the intrinsic dimensions of the image file.',
    })),
    w: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The intended display width of the image in pixels. This may\ndiffer from the intrinsic dimensions of the image file.',
    })),
    mimetype: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The mimetype of the image, e.g. `image/jpeg`.',
    })),
    size: typebox_1.Type.Optional(typebox_1.Type.Number({ description: 'Size of the image in bytes.' })),
    thumbnail_url: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'The URL (typically [`mxc://` URI](/client-server-api/#matrix-content-mxc-uris)) to a thumbnail of the image.\nOnly present if the thumbnail is unencrypted.',
    })),
    thumbnail_file: typebox_1.Type.Optional(typebox_1.Type.Unknown()),
    thumbnail_info: typebox_1.Type.Optional(exports.ThumbnailInfo),
});
exports.ImageMessageContent = typebox_1.Type.Object({
    body: typebox_1.Type.String({
        description: "A textual representation of the image. This could be the alt text of the image, the filename of the image, or some kind of content description for accessibility e.g. 'image attachment'.",
    }),
    info: typebox_1.Type.Optional(exports.ImageInfo),
    msgtype: typebox_1.Type.Literal('m.image'),
    url: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'Required if the file is unencrypted. The URL (typically [`mxc://` URI](/client-server-api/#matrix-content-mxc-uris))\nto the image.',
    })),
    file: typebox_1.Type.Optional(typebox_1.Type.Unknown()),
});
exports.VideoMessageContent = typebox_1.Type.Object({
    body: typebox_1.Type.String({
        description: "A description of the video e.g. 'Gangnam style', or some kind of content description for accessibility e.g. 'video attachment'.",
    }),
    info: typebox_1.Type.Optional(typebox_1.Type.Object({
        duration: typebox_1.Type.Optional(typebox_1.Type.Number({
            description: 'The duration of the video in milliseconds.',
        })),
        h: typebox_1.Type.Optional(typebox_1.Type.Number({ description: 'The height of the video in pixels.' })),
        w: typebox_1.Type.Optional(typebox_1.Type.Number({ description: 'The width of the video in pixels.' })),
        mimetype: typebox_1.Type.Optional(typebox_1.Type.String({
            description: 'The mimetype of the video e.g. `video/mp4`.',
        })),
        size: typebox_1.Type.Optional(typebox_1.Type.Number({ description: 'The size of the video in bytes.' })),
        thumbnail_url: typebox_1.Type.Optional(typebox_1.Type.String({
            description: 'The URL (typically [`mxc://` URI](/client-server-api/#matrix-content-mxc-uris)) to an image thumbnail of\nthe video clip. Only present if the thumbnail is unencrypted.',
        })),
        thumbnail_file: typebox_1.Type.Optional(typebox_1.Type.Unknown()),
        thumbnail_info: typebox_1.Type.Optional(exports.ThumbnailInfo),
    })),
    msgtype: typebox_1.Type.Literal('m.video'),
    url: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'Required if the file is unencrypted. The URL (typically [`mxc://` URI](/client-server-api/#matrix-content-mxc-uris))\nto the video clip.',
    })),
    file: typebox_1.Type.Optional(typebox_1.Type.Unknown()),
});
exports.AudioMessageContent = typebox_1.Type.Object({
    body: typebox_1.Type.String({
        description: "A description of the audio e.g. 'Bee Gees - Stayin' Alive', or some kind of content description for accessibility e.g. 'audio attachment'.",
    }),
    info: typebox_1.Type.Optional(typebox_1.Type.Object({
        duration: typebox_1.Type.Optional(typebox_1.Type.Number({
            description: 'The duration of the audio in milliseconds.',
        })),
        mimetype: typebox_1.Type.Optional(typebox_1.Type.String({
            description: 'The mimetype of the audio e.g. `audio/aac`.',
        })),
        size: typebox_1.Type.Optional(typebox_1.Type.Number({ description: 'The size of the audio clip in bytes.' })),
    })),
    msgtype: typebox_1.Type.Literal('m.audio'),
    url: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'Required if the file is unencrypted. The URL (typically [`mxc://` URI](/client-server-api/#matrix-content-mxc-uris))\nto the audio clip.',
    })),
    file: typebox_1.Type.Optional(typebox_1.Type.Unknown()),
});
exports.RoomMessage = typebox_1.Type.Intersect([
    typebox_1.Type.Omit((0, Events_1.RoomEvent)(typebox_1.Type.Unknown()), ['content', 'type']),
    typebox_1.Type.Object({
        content: typebox_1.Type.Union([
            exports.TextMessageContent,
            exports.NoticeMessageContent,
            exports.ImageMessageContent,
            exports.VideoMessageContent,
            exports.AudioMessageContent,
            Events_1.EmptyContent,
        ]),
        type: typebox_1.Type.Literal('m.room.message'),
    }),
]);
//# sourceMappingURL=RoomMessage.js.map