"use strict";
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerACLEvent = exports.ServerACLContent = void 0;
const typebox_1 = require("@sinclair/typebox");
const Events_1 = require("./Events");
exports.ServerACLContent = typebox_1.Type.Object({
    allow_ip_literals: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: 'True to allow server names that are IP address literals. False to\ndeny. Defaults to true if missing or otherwise not a boolean.\n\nThis is strongly recommended to be set to `false` as servers running\nwith IP literal names are strongly discouraged in order to require\nlegitimate homeservers to be backed by a valid registered domain name.',
    })),
    allow: typebox_1.Type.Optional(typebox_1.Type.Array(typebox_1.Type.String(), {
        description: 'The server names to allow in the room, excluding any port information.\nEach entry is interpreted as a [glob-style pattern](/appendices#glob-style-matching).\n\n**This defaults to an empty list when not provided, effectively disallowing\nevery server.**',
    })),
    deny: typebox_1.Type.Optional(typebox_1.Type.Array(typebox_1.Type.String(), {
        description: 'The server names to disallow in the room, excluding any port information.\nEach entry is interpreted as a [glob-style pattern](/appendices#glob-style-matching).\n\nThis defaults to an empty list when not provided.',
    })),
});
exports.ServerACLEvent = typebox_1.Type.Intersect([
    (0, Events_1.StateEvent)(exports.ServerACLContent),
    typebox_1.Type.Object({
        state_key: typebox_1.Type.Optional(typebox_1.Type.String({ description: 'A zero-length string.', pattern: '^$' })),
        type: typebox_1.Type.Literal('m.room.server_acl'),
    }),
]);
//# sourceMappingURL=ServerACL.js.map