import { StaticDecode } from '@sinclair/typebox';
import { MembershipEvent } from '../MatrixTypes/MembershipEvent';
import { Membership, MembershipChange } from './MembershipChange';
import { RoomMembershipRevision } from './MembershipRevision';
import { Map as PersistentMap, Set as PersistentSet } from 'immutable';
import { MatrixRoomID, StringEventID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
type MembershipByUserID = PersistentMap<StringUserID, MembershipChange>;
type MembershipByEventID = PersistentMap<StringEventID, MembershipChange>;
type MembershipByMembership = PersistentMap<Membership, PersistentSet<MembershipChange>>;
export declare class StandardRoomMembershipRevision implements RoomMembershipRevision {
    readonly room: MatrixRoomID;
    readonly membershipByUserID: MembershipByUserID;
    readonly membershipByEventID: MembershipByEventID;
    readonly membershipByMembership: MembershipByMembership;
    private constructor();
    static blankRevision(room: MatrixRoomID): StandardRoomMembershipRevision;
    members(): IterableIterator<MembershipChange>;
    membersOfMembership(membership: Membership): IterableIterator<MembershipChange>;
    hasEvent(eventID: StringEventID): boolean;
    membershipForUser(userID: StringUserID): MembershipChange | undefined;
    changesFromMembership(membershipEvents: StaticDecode<typeof MembershipEvent>[]): MembershipChange[];
    reviseFromChanges(changes: MembershipChange[]): StandardRoomMembershipRevision;
    reviseFromMembership(membershipEvents: StaticDecode<typeof MembershipEvent>[]): StandardRoomMembershipRevision;
}
export {};
//# sourceMappingURL=StandardRoomMembershipRevision.d.ts.map