"use strict";
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardSetRoomMembership = void 0;
const events_1 = __importDefault(require("events"));
const Action_1 = require("../Interface/Action");
const SetRoomMembership_1 = require("./SetRoomMembership");
class StandardSetRoomMembership extends events_1.default {
    constructor() {
        super();
        this.issuers = new Map();
        this.revisionListener = this.membershipRevision.bind(this);
    }
    getRevision(room) {
        var _a;
        return (_a = this.issuers.get(room)) === null || _a === void 0 ? void 0 : _a.currentRevision;
    }
    static async create(roomMembershipManager, roomsSet) {
        const setMembership = new StandardSetRoomMembership();
        const issuerResults = await Promise.all(roomsSet.map((room) => roomMembershipManager.getRoomMembershipRevisionIssuer(room)));
        for (const result of issuerResults) {
            if ((0, Action_1.isError)(result)) {
                return result.elaborate(`Unable to fetch a membership revision issuer while creating SetMembership`);
            }
            else {
                SetRoomMembership_1.SetRoomMembershipMirror.addRoom(setMembership, result.ok.room, result.ok);
            }
        }
        return (0, Action_1.Ok)(setMembership);
    }
    static blankSet() {
        return new StandardSetRoomMembership();
    }
    [SetRoomMembership_1.SetRoomMembershipMirrorCord.addRoom](room, issuer) {
        if (this.issuers.has(room.toRoomIDOrAlias())) {
            return;
        }
        this.issuers.set(room.toRoomIDOrAlias(), issuer);
        issuer.on('revision', this.revisionListener);
        this.emit('SetChange', room.toRoomIDOrAlias(), 'add', issuer.currentRevision);
    }
    [SetRoomMembership_1.SetRoomMembershipMirrorCord.removeRoom](room) {
        const issuer = this.issuers.get(room.toRoomIDOrAlias());
        if (issuer === undefined) {
            return;
        }
        this.issuers.delete(room.toRoomIDOrAlias());
        issuer.off('revision', this.revisionListener);
        this.emit('SetChange', room.toRoomIDOrAlias(), 'remove', issuer.currentRevision);
    }
    unregisterListeners() {
        for (const issuer of this.issuers.values()) {
            issuer.off('revision', this.revisionListener);
        }
    }
    get allRooms() {
        return [...this.issuers.values()].map((issuer) => issuer.currentRevision);
    }
    membershipRevision(...[nextRevision, changes, previousRevision]) {
        this.emit('membership', nextRevision.room.toRoomIDOrAlias(), nextRevision, changes, previousRevision);
    }
}
exports.StandardSetRoomMembership = StandardSetRoomMembership;
//# sourceMappingURL=StandardSetRoomMembership.js.map