import { DescriptionMeta } from '../DescriptionMeta';
import { Capability, CapabilityProviderDescription } from './CapabilityProvider';
/**
 * This is used to destructure contexts for capability providers that are
 * written for contexts that they don't understand.
 * For example, we provide standard capabilities in this library,
 * which won't be aware of the contexts that they eventually get used in.
 * Therefore, a client has to implement glue to destructure that context
 * for them.
 */
export type CapabilityContextGlue<HostContext = unknown, GuestContext = unknown> = {
    /** The name of the capability provider to provide glue for */
    name: string;
    glueMethod: (protectionDescription: DescriptionMeta, context: HostContext, capabilityProvider: CapabilityProviderDescription<GuestContext>) => Capability;
};
export declare function findCapabilityContextGlue(name: string): CapabilityContextGlue | undefined;
export declare function registerCapabilityContextGlue<HostContext = unknown, GuestContext = unknown>(glue: CapabilityContextGlue<HostContext, GuestContext>): void;
export declare function describeCapabilityContextGlue<HostContext = unknown, GuestContext = unknown>(glue: CapabilityContextGlue<HostContext, GuestContext>): void;
//# sourceMappingURL=CapabilityContextGlue.d.ts.map