"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.findCapabilityContextGlue = findCapabilityContextGlue;
exports.registerCapabilityContextGlue = registerCapabilityContextGlue;
exports.describeCapabilityContextGlue = describeCapabilityContextGlue;
const CapabilityProvider_1 = require("./CapabilityProvider");
const CAPABILITY_CONTEXT_GLUE = new Map();
function findCapabilityContextGlue(name) {
    return CAPABILITY_CONTEXT_GLUE.get(name);
}
function registerCapabilityContextGlue(glue) {
    const capabilityWithName = (0, CapabilityProvider_1.findCapabilityProvider)(glue.name);
    if (capabilityWithName === undefined) {
        throw new TypeError(`Cannot find a capability provider for the glue named ${glue.name}`);
    }
    CAPABILITY_CONTEXT_GLUE.set(glue.name, glue);
}
function describeCapabilityContextGlue(glue) {
    registerCapabilityContextGlue(glue);
}
//# sourceMappingURL=CapabilityContextGlue.js.map