"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventConsequences = void 0;
const typebox_1 = require("@sinclair/typebox");
const CapabilityInterface_1 = require("../CapabilityInterface");
const CapabilityProvider_1 = require("../CapabilityProvider");
const CapabilityMethodSchema_1 = require("./CapabilityMethodSchema");
exports.EventConsequences = typebox_1.Type.Intersect([
    typebox_1.Type.Object({
        consequenceForEvent: CapabilityMethodSchema_1.CapabilityMethodSchema,
    }),
    CapabilityProvider_1.Capability,
]);
(0, CapabilityInterface_1.describeCapabilityInterface)({
    name: 'EventConsequences',
    description: 'Capabilities for consequences against Matrix events',
    schema: exports.EventConsequences,
});
//# sourceMappingURL=EventConsequences.js.map