"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResultForUsersInSetBuilder = exports.ResultForUsersInRoomBuilder = exports.RoomSetResultBuilder = exports.StringTypeResultBuilder = void 0;
const Action_1 = require("../../../Interface/Action");
class StringTypeResultBuilder {
    constructor() {
        this.isEveryResultOk = true;
        this.numberOfFailedResults = 0;
        this.map = new Map();
    }
    addResult(key, result) {
        if ((0, Action_1.isError)(result)) {
            this.numberOfFailedResults += 1;
            this.isEveryResultOk = false;
        }
        this.map.set(key, result);
        return this;
    }
    getResult() {
        return {
            isEveryResultOk: this.isEveryResultOk,
            numberOfFailedResults: this.numberOfFailedResults,
            map: this.map,
        };
    }
}
exports.StringTypeResultBuilder = StringTypeResultBuilder;
exports.RoomSetResultBuilder = (StringTypeResultBuilder);
exports.ResultForUsersInRoomBuilder = (StringTypeResultBuilder);
class ResultForUsersInSetBuilder {
    constructor() {
        this.isEveryResultOk = true;
        this.numberOfFailedResults = 0;
        this.map = new Map();
    }
    addResult(userID, roomID, result) {
        if ((0, Action_1.isError)(result)) {
            this.numberOfFailedResults += 1;
            this.isEveryResultOk = false;
        }
        const entry = this.map.get(userID);
        if (entry === undefined) {
            this.map.set(userID, new exports.RoomSetResultBuilder().addResult(roomID, result));
        }
        else {
            entry.addResult(roomID, result);
        }
        return this;
    }
    getResult() {
        return {
            isEveryResultOk: this.isEveryResultOk,
            numberOfFailedResults: this.numberOfFailedResults,
            map: [...this.map.entries()].reduce((nextMap, [userID, roomSetResultBuilder]) => {
                nextMap.set(userID, roomSetResultBuilder.getResult());
                return nextMap;
            }, new Map()),
        };
    }
}
exports.ResultForUsersInSetBuilder = ResultForUsersInSetBuilder;
//# sourceMappingURL=RoomSetResult.js.map